/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.content;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.stateguard.InvalidStateException;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.content.maven.store.GAV;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.DigestExtractor;
import org.sonatype.nexus.repository.maven.internal.content.LegacyDatastoreMetadataUpdater;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.Maven2Metadata;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataBuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataException;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataRebuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

@FeatureFlag(name="nexus.maven.native.rebuild", enabledByDefault=true)
@Singleton
@Named
public class NativeDatastoreMetadataRebuilder
extends ComponentSupport
implements MetadataRebuilder {
    private static final String PATH_PREFIX = "/";
    private final int bufferSize;
    private final VersionScheme versionScheme;

    @Inject
    public NativeDatastoreMetadataRebuilder(@Named(value="${nexus.maven.metadata.rebuild.bufferSize:-1000}") int bufferSize) {
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Buffer size must be greater than 0");
        this.bufferSize = bufferSize;
        this.versionScheme = new GenericVersionScheme();
        this.log.debug("Chose {} for maven meadata rebuilds");
    }

    @Override
    public boolean rebuild(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        Worker worker = new Worker(repository, update, groupId, artifactId, baseVersion);
        boolean rebuiltMetadata = false;
        try {
            rebuiltMetadata = worker.rebuildMetadata();
            if (rebuildChecksums) {
                worker.rebuildChecksums();
            }
        }
        finally {
            this.maybeLogFailures(worker.failures);
        }
        return rebuiltMetadata;
    }

    private void maybeLogFailures(MultipleFailures failures) {
        if (failures.isEmpty()) {
            return;
        }
        this.log.warn("Errors encountered during metadata rebuild:");
        failures.getFailures().forEach(failure -> this.log.warn(failure.getMessage(), failure));
    }

    @Override
    @Deprecated
    public boolean rebuildInTransaction(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        return this.rebuild(repository, update, rebuildChecksums, groupId, artifactId, baseVersion);
    }

    @Override
    public Set<String> deleteMetadata(Repository repository, List<String[]> gavs) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(gavs);
        ArrayList paths = Lists.newArrayList();
        for (String[] gav : gavs) {
            MavenPath mavenPath = MetadataUtils.metadataPath(gav[0], gav[1], gav[2]);
            paths.add(StringUtils.prependIfMissing((String)mavenPath.main().getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0]));
            MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
            int n = hashTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = hashTypeArray[n2];
                paths.add(StringUtils.prependIfMissing((String)mavenPath.main().hash(hashType).getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0]));
                ++n2;
            }
        }
        MavenContentFacet mavenContentFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        HashSet deletedPaths = Sets.newHashSet();
        if (mavenContentFacet.delete(paths)) {
            deletedPaths.addAll(paths);
        }
        return deletedPaths;
    }

    private static Optional<String> chain(Optional<String> original, @Nullable String next) {
        if (original.isPresent()) {
            return Optional.ofNullable(next);
        }
        return Optional.empty();
    }

    private static Optional<HashCode> getChecksum(Optional<AssetBlob> assetBlob, MavenPath.HashType hashType) {
        return assetBlob.map(AssetBlob::checksums).map(checksums -> (String)checksums.get(hashType.name().toLowerCase())).map(HashCode::fromString);
    }

    private static void maybeRethrow(Exception e) {
        if (e instanceof TaskInterruptedException) {
            throw (TaskInterruptedException)((Object)e);
        }
        if (e instanceof InvalidStateException) {
            throw (InvalidStateException)e;
        }
    }

    private class Worker {
        private final MultipleFailures failures = new MultipleFailures();
        private final Repository repository;
        private final MavenContentFacet content;
        private final MavenPathParser mavenPathParser;
        private final LegacyDatastoreMetadataUpdater metadataUpdater;
        private final Optional<String> groupId;
        private final Optional<String> artifactId;
        private final Optional<String> baseVersion;
        private boolean rebuilt = false;

        public Worker(Repository repository, @Nullable boolean update, @Nullable String groupId, @Nullable String artifactId, String baseVersion) {
            this.metadataUpdater = new LegacyDatastoreMetadataUpdater(update, repository);
            this.content = (MavenContentFacet)repository.facet(MavenContentFacet.class);
            this.mavenPathParser = ((MavenContentFacet)repository.facet(MavenContentFacet.class)).getMavenPathParser();
            this.repository = repository;
            this.groupId = Optional.ofNullable(groupId);
            this.artifactId = NativeDatastoreMetadataRebuilder.chain(this.groupId, artifactId);
            this.baseVersion = NativeDatastoreMetadataRebuilder.chain(this.artifactId, baseVersion);
        }

        boolean rebuildMetadata() {
            FluentComponents components = this.content.components();
            NativeDatastoreMetadataRebuilder.this.log.debug("Beginning rebuild provided: r {} g {} a {} bv {}", new Object[]{this.repository.getName(), this.groupId, this.artifactId, this.baseVersion});
            this.groupId.map(Collections::singleton).map(Collection::stream).orElseGet(() -> components.namespaces().stream()).flatMap(namespace -> {
                this.rebuildGroupMetadata((String)namespace);
                return this.artifactId.map(Collections::singleton).map(Collection::stream).orElseGet(() -> components.names(namespace).stream()).map(name -> Pair.of((Object)namespace, (Object)name));
            }).flatMap(ga -> {
                Collection<String> gaBaseVersions = this.rebuildArtifactMetadata(this.repository, (String)ga.getLeft(), (String)ga.getRight());
                return this.baseVersion.map(Collections::singleton).map(Collection::stream).orElseGet(gaBaseVersions::stream).map(bv -> new GAV((String)ga.getLeft(), (String)ga.getRight(), (String)bv, 0));
            }).filter(gabv -> gabv.baseVersion.endsWith("-SNAPSHOT")).forEach(this::rebuildVersionMetadata);
            return this.rebuilt;
        }

        private void rebuildGroupMetadata(String namespace) {
            CancelableHelper.checkCancellation();
            MavenPath metadataPath = MetadataUtils.metadataPath(namespace, null, null);
            NativeDatastoreMetadataRebuilder.this.log.debug("Starting rebuild for repo {} g {}", (Object)this.repository.getName(), (Object)namespace);
            try {
                MetadataBuilder metadataBuilder = new MetadataBuilder();
                metadataBuilder.onEnterGroupId(namespace);
                for (Asset asset : Continuations.iterableOf(this.findMavenPluginsForNamespace(this.repository, namespace), (int)NativeDatastoreMetadataRebuilder.this.bufferSize)) {
                    CancelableHelper.checkCancellation();
                    this.processGroupPlugin(metadataBuilder, asset);
                }
                NativeDatastoreMetadataRebuilder.this.log.debug("Updating metadata for r {} g {}", (Object)this.repository.getName(), (Object)namespace);
                this.metadataUpdater.processMetadata(metadataPath, metadataBuilder.onExitGroupId());
                NativeDatastoreMetadataRebuilder.this.log.debug("Completed rebuild for repo {} g {}", (Object)this.repository.getName(), (Object)namespace);
                this.updateRebuilt(true);
            }
            catch (Exception e) {
                NativeDatastoreMetadataRebuilder.maybeRethrow(e);
                NativeDatastoreMetadataRebuilder.this.log.debug("Failed rebuild for repo {} g {}", (Object)this.repository.getName(), (Object)namespace);
                this.failures.add((Throwable)new MetadataException("Error processing metadata for path: " + metadataPath.getPath(), e));
                this.updateRebuilt(false);
            }
        }

        private void processGroupPlugin(MetadataBuilder metadataBuilder, Asset asset) {
            try {
                MavenPath mavenPath = this.mavenPathParser.parsePath(asset.path());
                MavenPath.Coordinates coordinates = mavenPath.getCoordinates();
                if (coordinates == null || !mavenPath.locateMainArtifact("jar").equals(mavenPath)) {
                    NativeDatastoreMetadataRebuilder.this.log.trace("Found unnecessary asset {}", (Object)asset.path());
                    return;
                }
                NativeDatastoreMetadataRebuilder.this.log.debug("Loading plugin data for asset {}", (Object)asset.path());
                metadataBuilder.addPlugin(MetadataUtils.getPluginPrefix(mavenPath, () -> this.content.assets().with(asset).download().openInputStream()), coordinates.getArtifactId(), (String)((Component)asset.component().get()).attributes("maven2").get("pom_name", String.class));
            }
            catch (Exception e) {
                NativeDatastoreMetadataRebuilder.maybeRethrow(e);
                this.failures.add((Throwable)new MetadataException("Error processing maven plugin in " + this.repository.getName() + " path  " + asset.path(), e));
            }
        }

        private Collection<String> rebuildArtifactMetadata(Repository repository, String namespace, String name) {
            CancelableHelper.checkCancellation();
            MavenPath metadataPath = MetadataUtils.metadataPath(namespace, name, null);
            Collection<String> baseVersions = this.content.getBaseVersions(namespace, name);
            NativeDatastoreMetadataRebuilder.this.log.debug("Starting rebuild for repo {} g {} a {}", new Object[]{repository.getName(), namespace, name});
            try {
                MetadataBuilder metadataBuilder = new MetadataBuilder();
                metadataBuilder.onEnterGroupId(namespace);
                metadataBuilder.onEnterArtifactId(name);
                NativeDatastoreMetadataRebuilder.this.log.trace("Found base versions {}", baseVersions);
                baseVersions.stream().forEach(metadataBuilder::addBaseVersion);
                Maven2Metadata metadata = metadataBuilder.onExitArtifactId();
                this.metadataUpdater.processMetadata(metadataPath, metadata);
                NativeDatastoreMetadataRebuilder.this.log.debug("Finished rebuild for repo {} g {} a {}", new Object[]{repository.getName(), namespace, name});
                this.updateRebuilt(true);
                return metadata.getBaseVersions().getVersions();
            }
            catch (Exception e) {
                NativeDatastoreMetadataRebuilder.maybeRethrow(e);
                this.failures.add((Throwable)new MetadataException("Error processing metadata for path: " + metadataPath.getPath(), e));
                this.updateRebuilt(false);
                return baseVersions != null ? baseVersions : Collections.emptySet();
            }
        }

        private void rebuildVersionMetadata(GAV gabv) {
            CancelableHelper.checkCancellation();
            String namespace = gabv.group;
            String name = gabv.name;
            String bVersion = gabv.baseVersion;
            MavenPath metadataPath = MetadataUtils.metadataPath(namespace, name, bVersion);
            NativeDatastoreMetadataRebuilder.this.log.debug("Starting rebuild for repo {} g {} a {}", new Object[]{this.repository.getName(), namespace, name, bVersion});
            try {
                Preconditions.checkArgument((boolean)bVersion.endsWith("-SNAPSHOT"));
                MetadataBuilder metadataBuilder = new MetadataBuilder();
                metadataBuilder.onEnterGroupId(namespace);
                metadataBuilder.onEnterArtifactId(name);
                metadataBuilder.onEnterBaseVersion(bVersion);
                Continuations.streamOf(this.findComponentsForBaseVersion(namespace, name, bVersion), (int)NativeDatastoreMetadataRebuilder.this.bufferSize).sorted(this::reverseSortByVersion).findFirst().map(FluentComponent::assets).map(Collection::stream).ifPresent(assets -> assets.map(Asset::path).map(this.mavenPathParser::parsePath).forEach(metadataBuilder::addArtifactVersion));
                Maven2Metadata metadata = metadataBuilder.onExitBaseVersion();
                this.metadataUpdater.processMetadata(metadataPath, metadata);
                NativeDatastoreMetadataRebuilder.this.log.debug("Finished rebuild for repo {} g {} a {}", new Object[]{this.repository.getName(), namespace, name, bVersion});
                this.updateRebuilt(true);
            }
            catch (Exception e) {
                NativeDatastoreMetadataRebuilder.maybeRethrow(e);
                this.failures.add((Throwable)new MetadataException("Error processing metadata for path: " + metadataPath.getPath(), e));
                this.updateRebuilt(false);
            }
        }

        private int reverseSortByVersion(Component a, Component b) {
            Version aVersion = this.parseVersion(a.version());
            Version bVersion = this.parseVersion(b.version());
            if (bVersion == null) {
                return -1;
            }
            if (aVersion == null) {
                return 1;
            }
            return bVersion.compareTo((Object)aVersion);
        }

        @Nullable
        private Version parseVersion(String version) {
            try {
                return NativeDatastoreMetadataRebuilder.this.versionScheme.parseVersion(version);
            }
            catch (InvalidVersionSpecificationException e) {
                NativeDatastoreMetadataRebuilder.this.log.warn("Invalid version: {}", (Object)version, (Object)e);
                return null;
            }
        }

        private BiFunction<Integer, String, Continuation<FluentComponent>> findComponentsForBaseVersion(String namespace, String name, String baseVersion) {
            return (limit, continuationToken) -> this.content.findComponentsForBaseVersion((int)limit, (String)continuationToken, namespace, name, baseVersion);
        }

        private BiFunction<Integer, String, Continuation<Asset>> findMavenPluginsForNamespace(Repository repository, String namespace) {
            return (limit, continuationToken) -> this.content.findMavenPluginAssetsForNamespace((int)limit, (String)continuationToken, namespace);
        }

        private void updateRebuilt(boolean rebuilt) {
            this.rebuilt |= rebuilt;
        }

        void rebuildChecksums() {
            FluentComponents components = this.content.components();
            this.groupId.map(Collections::singleton).map(Collection::stream).orElseGet(() -> components.namespaces().stream()).flatMap(namespace -> this.artifactId.map(Collections::singleton).map(Collection::stream).orElseGet(() -> components.names(namespace).stream()).map(name -> Pair.of((Object)namespace, (Object)name))).flatMap(ga -> this.baseVersion.map(bv -> Continuations.streamOf(this.findComponentsForBaseVersion((String)ga.getLeft(), (String)ga.getRight(), (String)bv), (int)NativeDatastoreMetadataRebuilder.this.bufferSize)).orElseGet(() -> this.componentsIfNotPresent(this.baseVersion, (String)ga.getLeft(), (String)ga.getRight()))).map(arg_0 -> ((FluentComponents)components).with(arg_0)).map(FluentComponent::assets).flatMap(Collection::stream).forEach(this::maybeRebuildChecksum);
        }

        private void maybeRebuildChecksum(Asset asset) {
            CancelableHelper.checkCancellation();
            MavenPath mavenPath = this.mavenPathParser.parsePath(asset.path());
            if (mavenPath.isSubordinate()) {
                NativeDatastoreMetadataRebuilder.this.log.trace("Skipping subordinate asset r {} {}", (Object)this.repository.getName(), (Object)asset.path());
                return;
            }
            NativeDatastoreMetadataRebuilder.this.log.debug("Verifying checksum for repository {} path {}", (Object)this.repository.getName(), (Object)asset.path());
            try {
                Optional assestBlob = asset.blob();
                Function<MavenPath.HashType, Optional<HashCode>> accessor = hashType -> NativeDatastoreMetadataRebuilder.getChecksum(assestBlob, hashType);
                boolean sha1ChecksumWasRebuilt = this.mayUpdateChecksum(accessor, mavenPath, MavenPath.HashType.SHA1);
                if (sha1ChecksumWasRebuilt) {
                    this.mayUpdateChecksum(accessor, mavenPath, MavenPath.HashType.SHA256);
                    this.mayUpdateChecksum(accessor, mavenPath, MavenPath.HashType.SHA512);
                    this.mayUpdateChecksum(accessor, mavenPath, MavenPath.HashType.MD5);
                }
            }
            catch (Exception e) {
                NativeDatastoreMetadataRebuilder.maybeRethrow(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean mayUpdateChecksum(Function<MavenPath.HashType, Optional<HashCode>> accessor, MavenPath mavenPath, MavenPath.HashType hashType) {
            MavenPath checksumPath;
            String assetChecksum;
            block13: {
                Optional<HashCode> checksum = accessor.apply(hashType);
                if (!checksum.isPresent()) {
                    NativeDatastoreMetadataRebuilder.this.log.warn("Asset with path {} lacks checksum {}", (Object)mavenPath, (Object)hashType);
                    return false;
                }
                assetChecksum = checksum.get().toString();
                checksumPath = mavenPath.hash(hashType);
                try {
                    Content checksumContent = this.content.get(checksumPath).orElse(null);
                    if (checksumContent == null) break block13;
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (InputStream is = checksumContent.openInputStream();){
                        String mavenChecksum = DigestExtractor.extract(is);
                        if (Objects.equals(assetChecksum, mavenChecksum)) {
                            return false;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    NativeDatastoreMetadataRebuilder.this.log.warn("Error reading {}", (Object)checksumPath, (Object)e);
                }
            }
            try {
                NativeDatastoreMetadataRebuilder.this.log.debug("Generating checksum file: {}", (Object)checksumPath);
                StringPayload mavenChecksum = new StringPayload(assetChecksum, "text/plain");
                this.content.put(checksumPath, (Payload)mavenChecksum);
                return true;
            }
            catch (IOException e) {
                NativeDatastoreMetadataRebuilder.this.log.warn("Error writing {}", (Object)checksumPath, (Object)e);
                throw new RuntimeException(e);
            }
        }

        private Stream<FluentComponent> componentsIfNotPresent(Optional<?> check, String namespace, String name) {
            if (check.isPresent()) {
                List empty = Collections.emptyList();
                return empty.stream();
            }
            BiFunction<Integer, String, Continuation> fn = (limit, continuationToken) -> this.content.findComponentsInGA((int)limit, (String)continuationToken, namespace, name);
            return Continuations.streamOf(fn, (int)NativeDatastoreMetadataRebuilder.this.bufferSize);
        }
    }
}

