/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.content;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.content.LegacyDatastoreMetadataUpdater;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.AbstractMetadataRebuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.AbstractMetadataUpdater;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.Maven2Metadata;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transactional;

@Deprecated
@Priority(value=0x7FFFFFFF)
@FeatureFlag(name="nexus.maven.datastore.legacy.rebuild", enabledByDefault=false)
@Singleton
@Named
public class LegacyDatastoreMetadataRebuilder
extends AbstractMetadataRebuilder {
    private static final String PATH_PREFIX = "/";

    @Inject
    public LegacyDatastoreMetadataRebuilder(@Named(value="${nexus.maven.metadata.rebuild.bufferSize:-1000}") int bufferSize, @Named(value="${nexus.maven.metadata.rebuild.timeoutSeconds:-60}") int timeoutSeconds) {
        super(bufferSize, timeoutSeconds);
    }

    @Override
    @Transactional
    public boolean rebuild(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        return this.rebuildInTransaction(repository, update, rebuildChecksums, groupId, artifactId, baseVersion);
    }

    @Override
    public boolean rebuildInTransaction(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        return new DatastoreWorker(repository, update, rebuildChecksums, groupId, artifactId, baseVersion, this.bufferSize, this.timeoutSeconds, new LegacyDatastoreMetadataUpdater(update, repository)).rebuildMetadata();
    }

    @Override
    protected Set<String> deleteAllMetadataFiles(Repository repository, String groupId, String artifactId, String baseVersion) {
        return super.deleteAllMetadataFiles(repository, groupId, artifactId, baseVersion);
    }

    @Override
    protected Set<String> deleteGavMetadata(Repository repository, String groupId, String artifactId, String baseVersion) {
        MavenPath gavMetadataPath = MetadataUtils.metadataPath(groupId, artifactId, baseVersion);
        MavenContentFacet mavenContentFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        try {
            return mavenContentFacet.deleteWithHashes(gavMetadataPath);
        }
        catch (IOException e) {
            this.log.warn("Error encountered when deleting metadata: repository={}", (Object)repository);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(Repository repository, MavenPath mavenPath) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(mavenPath.getPath()).find().isPresent();
    }

    @Override
    public Set<String> deleteMetadata(Repository repository, List<String[]> gavs) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(gavs);
        ArrayList paths = Lists.newArrayList();
        for (String[] gav : gavs) {
            MavenPath mavenPath = MetadataUtils.metadataPath(gav[0], gav[1], gav[2]);
            paths.add(StringUtils.prependIfMissing((String)mavenPath.main().getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0]));
            MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
            int n = hashTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = hashTypeArray[n2];
                paths.add(StringUtils.prependIfMissing((String)mavenPath.main().hash(hashType).getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0]));
                ++n2;
            }
        }
        MavenContentFacet mavenContentFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        HashSet deletedPaths = Sets.newHashSet();
        if (mavenContentFacet.delete(paths)) {
            deletedPaths.addAll(paths);
        }
        return deletedPaths;
    }

    protected static class DatastoreWorker
    extends AbstractMetadataRebuilder.Worker {
        public DatastoreWorker(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion, int bufferSize, int timeoutSeconds, AbstractMetadataUpdater metadataUpdater) {
            super(repository, update, rebuildChecksums, groupId, artifactId, baseVersion, bufferSize, timeoutSeconds, metadataUpdater, ((MavenContentFacet)repository.facet(MavenContentFacet.class)).getMavenPathParser());
        }

        @Override
        protected List<Map<String, Object>> browseGAVs() {
            Collection namespaces = Optional.ofNullable(this.groupId).map(Collections::singleton).map(set -> set).orElseGet(() -> this.content().components().namespaces());
            this.log.debug("Searching GAVs on {} namespaces", (Object)namespaces.size());
            return namespaces.stream().map(namespace -> this.namesInNamespace((String)namespace).map(name -> this.findBaseVersions((String)namespace, (String)name)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private Stream<String> namesInNamespace(String namespace) {
            if (this.groupId != null && this.artifactId != null) {
                return Collections.singleton(this.artifactId).stream();
            }
            return this.content().components().names(namespace).stream();
        }

        private MavenContentFacet content() {
            return (MavenContentFacet)this.repository.facet(MavenContentFacet.class);
        }

        private Map<String, Object> findBaseVersions(String namespace, String name) {
            FluentQuery query = this.content().components().byFilter("namespace = #{filterParams.namespace} AND name = #{filterParams.name}", (Map)ImmutableMap.of((Object)"namespace", (Object)namespace, (Object)"name", (Object)name));
            Set baseVersions = Continuations.streamOf((arg_0, arg_1) -> ((FluentQuery)query).browse(arg_0, arg_1)).map(component -> (String)component.attributes("maven2").get("baseVersion", String.class)).filter(Objects::nonNull).collect(Collectors.toSet());
            return ImmutableMap.of((Object)"groupId", (Object)namespace, (Object)"artifactId", (Object)name, (Object)"baseVersions", baseVersions);
        }

        @Override
        protected Content get(MavenPath mavenPath) throws IOException {
            return this.content().get(mavenPath).orElse(null);
        }

        @Override
        protected void put(MavenPath mavenPath, Payload payload) throws IOException {
            this.content().put(mavenPath, payload);
        }

        @Override
        protected void rebuildMetadataInner(String groupId, String artifactId, Set<String> baseVersions, MultipleFailures failures) {
            this.metadataBuilder.onEnterArtifactId(artifactId);
            FluentComponents components = this.content().components();
            for (String baseVersion : baseVersions) {
                CancelableHelper.checkCancellation();
                this.metadataBuilder.onEnterBaseVersion(baseVersion);
                this.processAssets(components, groupId, artifactId, baseVersion, this::processAsset);
                this.processMetadata(MetadataUtils.metadataPath(groupId, artifactId, baseVersion), this.metadataBuilder.onExitBaseVersion(), failures);
            }
            this.processMetadata(MetadataUtils.metadataPath(groupId, artifactId, null), this.metadataBuilder.onExitArtifactId(), failures);
        }

        private void processAssets(FluentComponents components, String groupId, String artifactId, String baseVersion, Consumer<Pair<FluentComponent, FluentAsset>> processor) {
            if (StringUtils.isBlank((CharSequence)groupId) || StringUtils.isBlank((CharSequence)artifactId) || StringUtils.isBlank((CharSequence)baseVersion)) {
                this.log.debug("Skipping assets for component with groupId={}, artifactId={}, and baseVersion={}", new Object[]{groupId, artifactId, baseVersion});
                return;
            }
            FluentQuery componentsByBaseVersion = components.byFilter("namespace = #{filterParams.groupId} AND name = #{filterParams.artifactId} AND (base_version = #{filterParams.baseVersion} OR version = #{filterParams.baseVersion})", (Map)ImmutableMap.of((Object)"groupId", (Object)groupId, (Object)"artifactId", (Object)artifactId, (Object)"baseVersion", (Object)baseVersion));
            Continuations.streamOf((arg_0, arg_1) -> ((FluentQuery)componentsByBaseVersion).browse(arg_0, arg_1), (int)this.bufferSize).forEach(component -> component.assets().stream().filter(asset -> !this.mavenPathParser.parsePath(asset.path()).isSubordinate()).forEach(asset -> processor.accept(Pair.of((Object)component, (Object)asset))));
        }

        @Override
        protected boolean refreshArtifact(String groupId, String artifactId, Set<String> baseVersions, MultipleFailures failures) {
            boolean isRequestedVersion;
            MavenPath metadataPath = MetadataUtils.metadataPath(groupId, artifactId, null);
            FluentComponents components = this.content().components();
            this.metadataBuilder.onEnterArtifactId(artifactId);
            boolean rebuiltAtLeastOneVersion = baseVersions.stream().map(v -> {
                CancelableHelper.checkCancellation();
                return this.refreshVersion(components, groupId, artifactId, (String)v, failures);
            }).reduce(Boolean::logicalOr).orElse(false);
            Maven2Metadata newMetadata = this.metadataBuilder.onExitArtifactId();
            boolean bl = isRequestedVersion = StringUtils.equals((CharSequence)this.groupId, (CharSequence)groupId) && StringUtils.equals((CharSequence)this.artifactId, (CharSequence)artifactId) && StringUtils.equals((CharSequence)this.baseVersion, null);
            if (isRequestedVersion || rebuiltAtLeastOneVersion || this.requiresRebuild(metadataPath)) {
                this.processMetadata(metadataPath, newMetadata, failures);
                return true;
            }
            this.log.debug("Skipping {}:{} for rebuild", (Object)groupId, (Object)artifactId);
            return false;
        }

        private boolean refreshVersion(FluentComponents components, String groupId, String artifactId, String version, MultipleFailures failures) {
            boolean isRequestedVersion;
            MavenPath metadataPath = MetadataUtils.metadataPath(groupId, artifactId, version);
            this.metadataBuilder.onEnterBaseVersion(this.baseVersion);
            this.processAssets(components, groupId, artifactId, version, this::processAsset);
            Maven2Metadata newMetadata = this.metadataBuilder.onExitBaseVersion();
            boolean bl = isRequestedVersion = StringUtils.equals((CharSequence)this.groupId, (CharSequence)groupId) && StringUtils.equals((CharSequence)this.artifactId, (CharSequence)artifactId) && StringUtils.equals((CharSequence)this.baseVersion, (CharSequence)version);
            if (isRequestedVersion || this.requiresRebuild(metadataPath)) {
                this.processMetadata(metadataPath, newMetadata, failures);
                return true;
            }
            this.log.debug("Skipping {}:{}:{} for rebuild", new Object[]{groupId, artifactId, version});
            return false;
        }

        private boolean requiresRebuild(MavenPath metadataPath) {
            FluentAssets assets = this.content().assets();
            Optional existingMetadata = assets.path(metadataPath.getPath()).find();
            return existingMetadata.map(this::getMetadataRebuildFlag).orElse(false);
        }

        private Boolean getMetadataRebuildFlag(FluentAsset asset) {
            return (Boolean)asset.attributes("metadataRebuild").get("forceRebuild", Boolean.class, (Object)false);
        }

        private void processAsset(Pair<FluentComponent, FluentAsset> componentAssetPair) {
            boolean sha1ChecksumWasRebuilt;
            CancelableHelper.checkCancellation();
            FluentComponent component = (FluentComponent)componentAssetPair.getLeft();
            FluentAsset asset = (FluentAsset)componentAssetPair.getRight();
            MavenPath mavenPath = this.mavenPathParser.parsePath(asset.path());
            this.metadataBuilder.addArtifactVersion(mavenPath);
            if (this.rebuildChecksums && (sha1ChecksumWasRebuilt = this.mayUpdateChecksum(mavenPath, MavenPath.HashType.SHA1))) {
                this.mayUpdateChecksum(mavenPath, MavenPath.HashType.SHA256);
                this.mayUpdateChecksum(mavenPath, MavenPath.HashType.SHA512);
                this.mayUpdateChecksum(mavenPath, MavenPath.HashType.MD5);
            }
            String packaging = (String)component.attributes(this.repository.getFormat().getValue()).get("packaging", String.class);
            this.log.debug("POM packaging: {}", (Object)packaging);
            if ("maven-plugin".equals(packaging)) {
                MavenPath mainArtifact = mavenPath.locateMainArtifact("jar");
                this.metadataBuilder.addPlugin(MetadataUtils.getPluginPrefix(mavenPath.locateMainArtifact("jar"), () -> this.get(mainArtifact).openInputStream()), component.name(), (String)component.attributes(this.repository.getFormat().getValue()).get("pom_name", String.class));
            }
        }

        @Override
        protected Optional<HashCode> getChecksum(MavenPath mavenPath, MavenPath.HashType hashType) {
            return this.content().assets().path(LegacyDatastoreMetadataRebuilder.PATH_PREFIX + mavenPath.getPath()).find().flatMap(Asset::blob).map(AssetBlob::checksums).map(checksums -> (String)checksums.get(hashType.name().toLowerCase())).map(HashCode::fromString);
        }
    }
}

