/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import javax.inject.Named;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.VersionPolicy;

@Named
public class VersionPolicyValidator {
    private static final String METADATA_SNAPSHOT_PATH_SUFFIX = "SNAPSHOT/maven-metadata.xml";

    public boolean validArtifactPath(VersionPolicy versionPolicy, MavenPath.Coordinates coordinates) {
        if (versionPolicy == VersionPolicy.SNAPSHOT) {
            return coordinates.isSnapshot();
        }
        if (versionPolicy == VersionPolicy.RELEASE) {
            return !coordinates.isSnapshot();
        }
        return true;
    }

    public boolean validMetadataPath(VersionPolicy versionPolicy, String path) {
        boolean isMetadataSnapshot = path.endsWith(METADATA_SNAPSHOT_PATH_SUFFIX);
        return !isMetadataSnapshot || versionPolicy != VersionPolicy.RELEASE;
    }
}

