/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.VersionPolicyValidator;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
public class VersionPolicyHandler
extends ComponentSupport
implements Handler {
    private final VersionPolicyValidator versionPolicyValidator;

    @Inject
    public VersionPolicyHandler(VersionPolicyValidator versionPolicyValidator) {
        this.versionPolicyValidator = (VersionPolicyValidator)Preconditions.checkNotNull((Object)versionPolicyValidator);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        MavenPath path = (MavenPath)context.getAttributes().require(MavenPath.class);
        MavenFacet mavenFacet = (MavenFacet)context.getRepository().facet(MavenFacet.class);
        VersionPolicy versionPolicy = mavenFacet.getVersionPolicy();
        MavenPath.Coordinates coordinates = path.getCoordinates();
        if (coordinates != null && !this.versionPolicyValidator.validArtifactPath(versionPolicy, coordinates)) {
            return VersionPolicyHandler.createResponse(context, "Repository version policy: " + (Object)((Object)versionPolicy) + " does not allow version: " + coordinates.getVersion());
        }
        if (!this.versionPolicyValidator.validMetadataPath(versionPolicy, path.main().getPath())) {
            return VersionPolicyHandler.createResponse(context, "Repository version policy: " + (Object)((Object)versionPolicy) + " does not allow metadata in path: " + path.getPath());
        }
        return context.proceed();
    }

    private static Response createResponse(Context context, String message) {
        switch (context.getRequest().getAction()) {
            case "GET": 
            case "HEAD": {
                return HttpResponses.notFound((String)message);
            }
        }
        return HttpResponses.badRequest((String)message);
    }
}

