/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.maven.index.reader.ChunkReader;
import org.apache.maven.index.reader.IndexReader;
import org.apache.maven.index.reader.IndexWriter;
import org.apache.maven.index.reader.Record;
import org.apache.maven.index.reader.RecordCompactor;
import org.apache.maven.index.reader.RecordExpander;
import org.apache.maven.index.reader.ResourceHandler;
import org.apache.maven.index.reader.Utils;
import org.apache.maven.index.reader.WritableResourceHandler;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenIndexFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

public abstract class MavenIndexPublisher
extends ComponentSupport {
    private static final String INDEX_PROPERTY_FILE = "/.index/nexus-maven-repository-index.properties";
    private static final String INDEX_MAIN_CHUNK_FILE = "/.index/nexus-maven-repository-index.gz";
    private static final RecordExpander RECORD_EXPANDER = new RecordExpander();
    protected static final RecordCompactor RECORD_COMPACTOR = new RecordCompactor();

    protected abstract MavenPathParser getMavenPathParser(Repository var1);

    protected abstract WritableResourceHandler getResourceHandler(Repository var1);

    protected abstract boolean delete(Repository var1, String var2) throws IOException;

    public boolean unpublishIndexFiles(Repository repository) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        return this.delete(repository, INDEX_PROPERTY_FILE) && this.delete(repository, INDEX_MAIN_CHUNK_FILE);
    }

    protected abstract Iterable<Iterable<Record>> getGroupRecords(List<Repository> var1, Closer var2) throws IOException;

    protected Iterable<Record> getRecords(Repository repository, Closer closer) throws IOException {
        ResourceHandler resourceHandler = (ResourceHandler)closer.register((Closeable)this.getResourceHandler(repository));
        IndexReader indexReader = (IndexReader)closer.register((Closeable)new IndexReader(null, resourceHandler));
        ChunkReader chunkReader = (ChunkReader)closer.register((Closeable)((ChunkReader)indexReader.iterator().next()));
        return Iterables.filter((Iterable)Iterables.transform((Iterable)chunkReader, arg_0 -> ((RecordExpander)RECORD_EXPANDER).apply(arg_0)), (Predicate)new RecordTypeFilter(Record.Type.ARTIFACT_ADD));
    }

    public abstract void publishHostedIndex(Repository var1, DuplicateDetectionStrategy<Record> var2) throws IOException;

    public void publishGroupIndex(Repository groupRepository, List<Repository> leafMembers, DuplicateDetectionStrategy<Record> strategy) throws IOException {
        ArrayList<String> withoutIndex = new ArrayList<String>();
        Iterator<Repository> ri = leafMembers.iterator();
        while (ri.hasNext()) {
            Repository leafMemberRepository = ri.next();
            if (((MavenIndexFacet)leafMemberRepository.facet(MavenIndexFacet.class)).lastPublished() != null) continue;
            withoutIndex.add(leafMemberRepository.getName());
            ri.remove();
        }
        if (!withoutIndex.isEmpty()) {
            this.log.info("Following members of group {} have no index, will not participate in merged index: {}", (Object)groupRepository.getName(), withoutIndex);
        }
        this.publishMergedIndex(groupRepository, leafMembers, strategy);
    }

    public void publishProxyIndex(Repository repository, Boolean cacheFallback, DuplicateDetectionStrategy<Record> strategy) throws IOException {
        if (!this.prefetchIndexFiles(repository)) {
            if (Boolean.TRUE.equals(cacheFallback)) {
                this.log.debug("No remote index found... generating partial index from caches");
                this.publishHostedIndex(repository, strategy);
            } else {
                this.log.debug("No remote index found... nothing to publish");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void publishMergedIndex(Repository target, List<Repository> repositories, DuplicateDetectionStrategy<Record> duplicateDetectionStrategy) throws IOException {
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull(repositories);
        try (Closer closer = Closer.create();){
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    WritableResourceHandler resourceHandler = this.getResourceHandler(target);
                    try {
                        try (IndexWriter indexWriter = new IndexWriter(resourceHandler, target.getName(), false);){
                            indexWriter.writeChunk(Iterables.transform(MavenIndexPublisher.decorate(Iterables.filter((Iterable)Iterables.concat(this.getGroupRecords(repositories, closer)), duplicateDetectionStrategy), target.getName()), arg_0 -> ((RecordCompactor)RECORD_COMPACTOR).apply(arg_0)).iterator());
                        }
                        if (resourceHandler == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (resourceHandler == null) throw throwable;
                        resourceHandler.close();
                        throw throwable;
                    }
                    resourceHandler.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
        }
    }

    /*
     * Loose catch block
     */
    public DateTime lastPublished(Repository repository) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (WritableResourceHandler resourceHandler = this.getResourceHandler(repository);){
                DateTime dateTime;
                IndexReader indexReader;
                Throwable throwable2;
                block21: {
                    throwable2 = null;
                    Object var6_10 = null;
                    indexReader = new IndexReader(null, (ResourceHandler)resourceHandler);
                    dateTime = new DateTime(indexReader.getPublishedTimestamp().getTime());
                    if (indexReader == null) break block21;
                    indexReader.close();
                }
                return dateTime;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (indexReader != null) {
                                indexReader.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException e) {
            this.log.debug("No index found in {}", (Object)repository, (Object)e);
            return null;
        }
    }

    public boolean prefetchIndexFiles(Repository repository) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkArgument((boolean)"proxy".equals(repository.getType().getValue()));
        MavenPathParser mavenPathParser = this.getMavenPathParser(repository);
        return MavenIndexPublisher.prefetch(repository, INDEX_PROPERTY_FILE, mavenPathParser) && MavenIndexPublisher.prefetch(repository, INDEX_MAIN_CHUNK_FILE, mavenPathParser);
    }

    private static boolean prefetch(Repository repository, String path, MavenPathParser mavenPathParser) throws IOException {
        MavenPath mavenPath = mavenPathParser.parsePath(path);
        Request getRequest = new Request.Builder().action("GET").path(path).build();
        Context context = new Context(repository, getRequest);
        context.getAttributes().set(MavenPath.class, (Object)mavenPath);
        return ((ProxyFacet)repository.facet(ProxyFacet.class)).get(context) != null;
    }

    protected static String pathExtension(String path) {
        int lastDot;
        String filename = path.toLowerCase(Locale.ENGLISH);
        if (filename.endsWith("tar.gz")) {
            return "tar.gz";
        }
        if (filename.endsWith("tar.bz2")) {
            return "tar.bz2";
        }
        int lastSep = filename.lastIndexOf(47);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return null;
    }

    protected static Iterable<Record> decorate(Iterable<Record> iterable, String repositoryName) {
        TreeSet allGroups = new TreeSet();
        TreeSet rootGroups = new TreeSet();
        return Iterables.transform((Iterable)Iterables.concat(Collections.singletonList(Utils.descriptor((String)repositoryName)), iterable, Collections.singletonList(Utils.allGroups(allGroups)), Collections.singletonList(Utils.rootGroups(rootGroups))), rec -> {
            if (Record.Type.DESCRIPTOR == rec.getType()) {
                return rec;
            }
            if (Record.Type.ALL_GROUPS == rec.getType()) {
                return Utils.allGroups((Collection)allGroups);
            }
            if (Record.Type.ROOT_GROUPS == rec.getType()) {
                return Utils.rootGroups((Collection)rootGroups);
            }
            String groupId = (String)rec.get(Record.GROUP_ID);
            if (groupId != null) {
                allGroups.add(groupId);
                rootGroups.add(Utils.rootGroup((String)groupId));
            }
            return rec;
        });
    }

    protected static String determineContentType(String name) {
        String contentType;
        if (name.endsWith(".properties")) {
            contentType = "text/plain";
        } else if (name.endsWith(".gz")) {
            contentType = "application/gzip";
        } else {
            throw new IllegalArgumentException("Unsupported MI index resource:" + name);
        }
        return contentType;
    }

    protected static StreamPayload createStreamPayload(Path path, String contentType) throws IOException {
        return new StreamPayload(() -> new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), Files.size(path), contentType);
    }

    protected static class RecordTypeFilter
    implements Predicate<Record> {
        private final List<Record.Type> allowedTypes;

        public RecordTypeFilter(Record.Type ... allowedTypes) {
            this.allowedTypes = Arrays.asList(allowedTypes);
        }

        public boolean apply(Record input) {
            return this.allowedTypes.contains(input.getType());
        }
    }
}

