/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.DigestExtractor;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.mime.DefaultContentValidator;

@Named(value="maven2")
@Singleton
public class MavenContentValidator
extends ComponentSupport
implements ContentValidator {
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public MavenContentValidator(DefaultContentValidator defaultContentValidator) {
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, InputStreamSupplier contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        if (contentName != null) {
            if (contentName.endsWith(".pom")) {
                return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, String.valueOf(contentName) + ".xml", declaredContentType);
            }
            if (this.isHashContentType(contentName)) {
                if (strictContentTypeValidation) {
                    Throwable throwable = null;
                    Object var7_8 = null;
                    try (InputStream is = contentSupplier.get();){
                        String digestCandidate = DigestExtractor.extract(is);
                        if (!DigestExtractor.isDigest(digestCandidate)) {
                            throw new InvalidContentException("Not a Maven2 digest: " + contentName);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (declaredContentType != null) {
                    return declaredContentType;
                }
            }
        }
        return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, contentName, declaredContentType);
    }

    private boolean isHashContentType(String contentName) {
        return MavenPath.HashType.ALGORITHMS.stream().anyMatch(algorithm -> contentName.endsWith(algorithm.name()));
    }
}

