/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.internal.search.Maven2SearchResultComponentGenerator;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentFinder;
import org.sonatype.nexus.repository.storage.ComponentStore;
import org.sonatype.nexus.repository.storage.DefaultComponentFinder;

@Singleton
@Named(value="maven2")
public class Maven2ComponentFinder
implements ComponentFinder {
    @Inject
    ComponentStore componentStore;
    @Inject
    DefaultComponentFinder defaultComponentFinder;

    public List<Component> findMatchingComponents(Repository repository, String componentId, String componentGroup, String componentName, String componentVersion) {
        if (Maven2SearchResultComponentGenerator.isSnapshotId(componentId)) {
            Preconditions.checkNotNull((Object)componentVersion);
            return this.componentStore.getAllMatchingComponents(repository, componentGroup, componentName, (Map)ImmutableMap.of((Object)"baseVersion", (Object)componentVersion));
        }
        return this.defaultComponentFinder.findMatchingComponents(repository, componentId, componentGroup, componentName, componentVersion);
    }
}

