/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.api;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.maven.api.MavenAttributes;
import org.sonatype.nexus.repository.maven.api.MavenHostedApiRepository;
import org.sonatype.nexus.repository.maven.api.MavenProxyApiRepository;
import org.sonatype.nexus.repository.maven.rest.HttpClientAttributesWithPreemptiveAuth;
import org.sonatype.nexus.repository.maven.rest.HttpClientConnectionAuthenticationAttributesWithPreemptive;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.HttpClientAttributes;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named(value="maven2")
public class MavenApiRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    private static final String MAVEN = "maven";

    @Inject
    public MavenApiRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public AbstractApiRepository adapt(Repository repository) {
        boolean online = repository.getConfiguration().isOnline();
        String name = repository.getName();
        String url = repository.getUrl();
        switch (repository.getType().toString()) {
            case "hosted": {
                return new MavenHostedApiRepository(name, url, online, this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.createMavenAttributes(repository), this.getComponentAttributes(repository));
            }
            case "proxy": {
                return new MavenProxyApiRepository(name, url, online, (StorageAttributes)this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.createMavenAttributes(repository), this.getReplicationAttributes(repository));
            }
        }
        return super.adapt(repository);
    }

    private MavenAttributes createMavenAttributes(Repository repository) {
        String versionPolicy = (String)repository.getConfiguration().attributes(MAVEN).get("versionPolicy", String.class);
        String layoutPolicy = (String)repository.getConfiguration().attributes(MAVEN).get("layoutPolicy", String.class);
        String contentDisposition = (String)repository.getConfiguration().attributes(MAVEN).get("contentDisposition", String.class);
        return new MavenAttributes(versionPolicy, layoutPolicy, contentDisposition);
    }

    protected HttpClientAttributesWithPreemptiveAuth getHttpClientAttributes(Repository repository) {
        HttpClientAttributes httpClientAttributes = super.getHttpClientAttributes(repository);
        HttpClientConnectionAuthenticationAttributesWithPreemptive authentication = null;
        Configuration configuration = repository.getConfiguration();
        NestedAttributesMap httpclient = configuration.attributes("httpclient");
        if (httpclient.contains("authentication")) {
            NestedAttributesMap authenticationMap = httpclient.child("authentication");
            Boolean preemptive = (Boolean)authenticationMap.get("preemptive", Boolean.class);
            authentication = new HttpClientConnectionAuthenticationAttributesWithPreemptive(httpClientAttributes.getAuthentication(), preemptive);
        }
        return new HttpClientAttributesWithPreemptiveAuth(httpClientAttributes, authentication);
    }
}

