/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.maven.model.Model;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.maven.LayoutPolicy;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenValidatingComponentUpload;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.Maven2MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.MavenPomGenerator;
import org.sonatype.nexus.repository.maven.internal.VersionPolicyValidator;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadRegexMap;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.upload.ValidatingComponentUpload;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;
import org.sonatype.nexus.rest.ValidationErrorsException;

public abstract class MavenUploadHandlerSupport
extends UploadHandlerSupport {
    protected static final String VERSION = "version";
    protected static final String ARTIFACT_ID = "artifactId";
    protected static final String GROUP_ID = "groupId";
    protected static final String GENERATE_POM = "generate-pom";
    protected static final String EXTENSION = "extension";
    protected static final String CLASSIFIER = "classifier";
    protected static final String PACKAGING = "packaging";
    private static final String MAVEN_POM_PROPERTY_PREFIX = "${";
    private static final String COMPONENT_COORDINATES_GROUP = "Component coordinates";
    private static final String GENERATE_POM_DISPLAY = "Generate a POM file with these coordinates";
    private static final String ARTIFACT_ID_DISPLAY = "Artifact ID";
    private static final String GROUP_ID_DISPLAY = "Group ID";
    private static final Set<String> ignoredPaths = Sets.newHashSet((Object[])new String[]{"/archetype-catalog.xml", "archetype-catalog.xml"});
    protected final Maven2MavenPathParser parser;
    protected final VariableResolverAdapter variableResolverAdapter;
    protected final ContentPermissionChecker contentPermissionChecker;
    protected final VersionPolicyValidator versionPolicyValidator;
    protected final MavenPomGenerator mavenPomGenerator;
    private UploadDefinition definition;

    public MavenUploadHandlerSupport(Maven2MavenPathParser parser, VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, VersionPolicyValidator versionPolicyValidator, MavenPomGenerator mavenPomGenerator, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.parser = parser;
        this.variableResolverAdapter = variableResolverAdapter;
        this.contentPermissionChecker = contentPermissionChecker;
        this.versionPolicyValidator = versionPolicyValidator;
        this.mavenPomGenerator = mavenPomGenerator;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)upload);
        if (VersionPolicy.SNAPSHOT.equals((Object)this.getVersionPolicy(repository))) {
            throw new ValidationErrorsException("Upload to snapshot repositories not supported, use the maven client.");
        }
        AssetUpload pomAsset = this.findPomAsset(upload);
        try (TempBlob pom = null;){
            if (pomAsset != null) {
                PartPayload payload = pomAsset.getPayload();
                pom = this.createTempBlob(repository, payload);
                pomAsset.setPayload((PartPayload)new TempBlobPartPayload(payload, pom));
            }
            String basePath = this.getBasePath(upload, pom);
            this.doValidation(repository, basePath, upload.getAssetUploads());
            UploadResponse uploadResponse = this.getUploadResponse(repository, upload, basePath);
            return uploadResponse;
        }
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        ImportFileConfiguration configuration = new ImportFileConfiguration(repository, content, path);
        return this.handle(configuration);
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        String path = configuration.getAssetName();
        if (ignoredPaths.contains(path)) {
            this.log.debug("skipping {} as it is on the ignore list.", (Object)path);
            return null;
        }
        MavenPath mavenPath = this.parser.parsePath(path);
        try {
            this.doImportValidation(repository, mavenPath);
        }
        catch (ValidationErrorsException e) {
            this.log.warn(e.getMessage(), (Throwable)(this.log.isDebugEnabled() ? e : null));
            return null;
        }
        if (!configuration.isHardLinkingEnabled() && mavenPath.getHashType() != null) {
            this.log.debug("skipping hash file {}", (Object)mavenPath);
            return null;
        }
        return this.doPut(configuration);
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            List<UploadFieldDefinition> componentFields = Arrays.asList(new UploadFieldDefinition(GROUP_ID, GROUP_ID_DISPLAY, null, false, UploadFieldDefinition.Type.STRING, COMPONENT_COORDINATES_GROUP), new UploadFieldDefinition(ARTIFACT_ID, ARTIFACT_ID_DISPLAY, null, false, UploadFieldDefinition.Type.STRING, COMPONENT_COORDINATES_GROUP), new UploadFieldDefinition(VERSION, false, UploadFieldDefinition.Type.STRING, COMPONENT_COORDINATES_GROUP), new UploadFieldDefinition(GENERATE_POM, GENERATE_POM_DISPLAY, null, true, UploadFieldDefinition.Type.BOOLEAN, COMPONENT_COORDINATES_GROUP), new UploadFieldDefinition(PACKAGING, true, UploadFieldDefinition.Type.STRING, COMPONENT_COORDINATES_GROUP));
            List<UploadFieldDefinition> assetFields = Arrays.asList(new UploadFieldDefinition(CLASSIFIER, true, UploadFieldDefinition.Type.STRING), new UploadFieldDefinition(EXTENSION, false, UploadFieldDefinition.Type.STRING));
            UploadRegexMap regexMap = new UploadRegexMap("-(?:(?:\\.?\\d)+)(?:-(?:SNAPSHOT|\\d+))?(?:-(\\w+))?\\.((?:\\.?\\w)+)$", new String[]{CLASSIFIER, EXTENSION});
            this.definition = this.getDefinition("maven2", true, componentFields, assetFields, regexMap);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public ValidatingComponentUpload getValidatingComponentUpload(ComponentUpload componentUpload) {
        return new MavenValidatingComponentUpload(this.getDefinition(), componentUpload);
    }

    protected void maybeGeneratePom(Repository repository, ComponentUpload componentUpload, String basePath, ContentAndAssetPathResponseData responseData) throws IOException {
        if (MavenUploadHandlerSupport.isGeneratePom(componentUpload.getField(GENERATE_POM))) {
            String pomPath = this.generatePom(repository, basePath, (String)componentUpload.getFields().get(GROUP_ID), (String)componentUpload.getFields().get(ARTIFACT_ID), (String)componentUpload.getFields().get(VERSION), (String)componentUpload.getFields().get(PACKAGING));
            responseData.addAssetPath(pomPath);
        }
    }

    protected void validateVersionPolicy(Repository repository, MavenPath mavenPath) {
        boolean valid;
        VersionPolicy versionPolicy = this.getVersionPolicy(repository);
        boolean bl = valid = this.parser.isRepositoryMetadata(mavenPath) ? this.versionPolicyValidator.validMetadataPath(versionPolicy, mavenPath.main().getPath()) : this.versionPolicyValidator.validArtifactPath(versionPolicy, mavenPath.getCoordinates());
        if (!valid) {
            throw new ValidationErrorsException(String.format("Version policy mismatch, cannot upload %s content to %s repositories for file '%s'", versionPolicy.equals((Object)VersionPolicy.RELEASE) ? VersionPolicy.SNAPSHOT.name() : VersionPolicy.RELEASE.name(), versionPolicy.name(), mavenPath.getPath()));
        }
    }

    protected abstract UploadResponse getUploadResponse(Repository var1, ComponentUpload var2, String var3) throws IOException;

    protected abstract Content doPut(Repository var1, MavenPath var2, Payload var3) throws IOException;

    protected abstract Content doPut(ImportFileConfiguration var1) throws IOException;

    protected abstract VersionPolicy getVersionPolicy(Repository var1);

    protected abstract TempBlob createTempBlob(Repository var1, PartPayload var2);

    protected void doValidation(Repository repository, String basePath, List<AssetUpload> assetUploads) {
        for (AssetUpload asset : assetUploads) {
            MavenPath mavenPath = this.getMavenPath(basePath, asset);
            this.doCoordinatesValidation(mavenPath);
            this.validateVersionPolicy(repository, mavenPath);
            this.ensurePermitted(repository.getName(), "maven2", mavenPath.getPath(), this.toMap(mavenPath.getCoordinates()));
        }
    }

    private void doImportValidation(Repository repository, MavenPath mavenPath) {
        LayoutPolicy layoutPolicy = ((MavenFacet)repository.facet(MavenFacet.class)).layoutPolicy();
        if (layoutPolicy == LayoutPolicy.STRICT) {
            if (!this.parser.isRepositoryMetadata(mavenPath)) {
                this.doCoordinatesValidation(mavenPath);
            }
            this.validateVersionPolicy(repository, mavenPath);
        }
        this.ensurePermitted(repository.getName(), "maven2", mavenPath.getPath(), this.toMap(mavenPath.getCoordinates()));
    }

    private void doCoordinatesValidation(MavenPath mavenPath) {
        if (mavenPath.getCoordinates() == null) {
            throw new ValidationErrorsException(String.format("Cannot generate maven coordinate from assembled path '%s'", mavenPath.getPath()));
        }
    }

    protected String generatePom(Repository repository, String basePath, String groupId, String artifactId, String version, @Nullable String packaging) throws IOException {
        this.log.debug("Generating pom for {} {} {} with packaging {}", new Object[]{groupId, artifactId, version, packaging});
        String pom = this.mavenPomGenerator.generatePom(groupId, artifactId, version, packaging);
        MavenPath mavenPath = this.parser.parsePath(String.valueOf(basePath) + ".pom");
        this.storeAssetContent(repository, mavenPath, (Payload)new StringPayload(pom, "text/xml"));
        return mavenPath.getPath();
    }

    protected AssetUpload findPomAsset(ComponentUpload componentUpload) {
        return componentUpload.getAssetUploads().stream().filter(asset -> "pom".equals(asset.getField(EXTENSION)) && Strings2.isBlank((String)asset.getField(CLASSIFIER))).findFirst().orElse(null);
    }

    protected static boolean isGeneratePom(String generatePom) {
        return "on".equals(generatePom) || Boolean.parseBoolean(generatePom);
    }

    protected ContentAndAssetPathResponseData createAssets(Repository repository, String basePath, List<AssetUpload> assetUploads) throws IOException {
        ContentAndAssetPathResponseData responseData = new ContentAndAssetPathResponseData();
        for (AssetUpload asset : assetUploads) {
            MavenPath mavenPath = this.getMavenPath(basePath, asset);
            Content content = this.storeAssetContent(repository, mavenPath, (Payload)asset.getPayload());
            if (responseData.getContent() == null) {
                responseData.setContent(content);
            }
            responseData.addAssetPath(mavenPath.getPath());
            if (responseData.getCoordinates() != null) continue;
            responseData.setCoordinates(mavenPath.getCoordinates());
        }
        return responseData;
    }

    private MavenPath getMavenPath(String basePath, AssetUpload asset) {
        StringBuilder path = new StringBuilder(basePath);
        String classifier = (String)asset.getFields().get(CLASSIFIER);
        if (!Strings2.isEmpty((String)classifier)) {
            path.append('-').append(classifier);
        }
        path.append('.').append((String)asset.getFields().get(EXTENSION));
        return this.parser.parsePath(path.toString());
    }

    protected Content storeAssetContent(Repository repository, MavenPath mavenPath, Payload payload) throws IOException {
        return this.doPut(repository, mavenPath, payload);
    }

    protected String getBasePath(ComponentUpload componentUpload, TempBlob pom) throws IOException {
        if (pom != null) {
            return this.createBasePathFromPom(pom);
        }
        return this.createBasePath((String)componentUpload.getFields().get(GROUP_ID), (String)componentUpload.getFields().get(ARTIFACT_ID), (String)componentUpload.getFields().get(VERSION));
    }

    private String createBasePath(String groupId, String artifactId, String version) {
        ArrayList parts = Lists.newArrayList((Object[])groupId.split("\\."));
        parts.addAll(Arrays.asList(artifactId, version, artifactId));
        return String.join((CharSequence)"-", String.join((CharSequence)"/", parts), version);
    }

    private String createBasePathFromPom(TempBlob tempBlob) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = tempBlob.get();){
            Model model = MavenModels.readModel(in);
            this.validatePom(model);
            return this.createBasePath(Objects.requireNonNull(this.getGroupId(model)), this.getArtifactId(model), this.getVersion(model));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    public void validatePom(Model model) {
        if (model == null) {
            throw new ValidationErrorsException("The provided POM file is invalid.");
        }
        String groupId = this.getGroupId(model);
        String version = this.getVersion(model);
        String artifactId = this.getArtifactId(model);
        if (groupId == null || artifactId == null || version == null || groupId.startsWith(MAVEN_POM_PROPERTY_PREFIX) || artifactId.startsWith(MAVEN_POM_PROPERTY_PREFIX) || version.startsWith(MAVEN_POM_PROPERTY_PREFIX)) {
            throw new ValidationErrorsException(String.format("The provided POM file is invalid.  Could not retrieve valid G:A:V parameters (%s:%s:%s)", groupId, artifactId, version));
        }
    }

    private String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    private String getArtifactId(Model model) {
        return model.getArtifactId();
    }

    private String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    protected Map<String, String> toMap(MavenPath.Coordinates coordinates) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (coordinates != null) {
            map.put(GROUP_ID, coordinates.getGroupId());
            map.put(ARTIFACT_ID, coordinates.getArtifactId());
            map.put(VERSION, coordinates.getVersion());
            if (coordinates.getClassifier() != null) {
                map.put(CLASSIFIER, coordinates.getClassifier());
            }
            map.put(EXTENSION, coordinates.getExtension());
        }
        return map;
    }

    public boolean supportsExportImport() {
        return true;
    }

    public static class ContentAndAssetPathResponseData {
        Content content;
        List<String> assetPaths = Lists.newArrayList();
        MavenPath.Coordinates coordinates;

        public void setContent(Content content) {
            this.content = content;
        }

        public void setCoordinates(MavenPath.Coordinates coordinates) {
            this.coordinates = coordinates;
        }

        public void addAssetPath(String assetPath) {
            this.assetPaths.add(assetPath);
        }

        public Content getContent() {
            return this.content;
        }

        public MavenPath.Coordinates getCoordinates() {
            return this.coordinates;
        }

        public List<String> getAssetPaths() {
            return this.assetPaths;
        }

        public UploadResponse uploadResponse() {
            return new UploadResponse(this.content, this.assetPaths);
        }
    }
}

