/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.replication.AssetReplicationFilter;
import org.sonatype.nexus.repository.replication.BlobEventType;

@Named(value="maven2")
@Singleton
public class MavenAssetReplicationFilter
implements AssetReplicationFilter {
    final List<String> filterSuffixes = HashAlgorithm.ALL_HASH_ALGORITHMS.values().stream().map(this::hashSuffix).collect(Collectors.toList());

    @Inject
    public MavenAssetReplicationFilter() {
    }

    public boolean test(BlobEventType blobEventType, String assetPath) {
        return this.filterSuffixes.stream().noneMatch(assetPath::endsWith);
    }

    private String hashSuffix(HashAlgorithm hashAlgorithm) {
        return "." + hashAlgorithm.name();
    }
}

