/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.upgrade;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Deprecated
public abstract class MavenIndexUpgrade
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String SELECT_MAVEN_REPOSITORIES = "select id from repository where recipe_name in ('maven2-hosted', 'maven2-proxy')";
    private static final String SELECT_REPOSITORY_ATTRIBUTES = "select attributes from maven2_content_repository where config_repository_id = ?";
    private static final String UPDATE_REPOSITORY_ATTRIBUTES = "update maven2_content_repository set attributes = ? where config_repository_id = ?";
    public static final String ID = "id";

    public void migrate(Connection connection) throws Exception {
        this.log.info("Searching for maven repositories that need a search index update");
        ObjectMapper objectMapper = new ObjectMapper();
        List<String> repositoryIds = this.getRepositoryIds(connection);
        for (String id : repositoryIds) {
            String attributes = this.getRepositoryAttributes(connection, id);
            if (attributes == null) continue;
            ObjectNode json = (ObjectNode)objectMapper.readTree(attributes);
            json.put("search_index_outdated", true);
            this.setRepositoryAttributes(connection, id, objectMapper.writeValueAsBytes((Object)json));
        }
    }

    private List<String> getRepositoryIds(Connection connection) throws SQLException {
        ArrayList<String> repositoryIds = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement s = connection.createStatement();){
            ResultSet rs = s.executeQuery(SELECT_MAVEN_REPOSITORIES);
            while (rs.next()) {
                repositoryIds.add(rs.getString(ID));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return repositoryIds;
    }

    @Nullable
    private String getRepositoryAttributes(Connection connection, String repositoryId) throws SQLException {
        block12: {
            PreparedStatement ps;
            block10: {
                String string;
                block11: {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    ps = connection.prepareStatement(SELECT_REPOSITORY_ATTRIBUTES);
                    try {
                        ps.setString(1, repositoryId);
                        ResultSet rs = ps.executeQuery();
                        if (!rs.next()) break block10;
                        string = rs.getString(1);
                        if (ps == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (ps != null) {
                                ps.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    ps.close();
                }
                return string;
            }
            this.log.warn("Could not find row in maven2_content_repository for config_repository_id = {}", (Object)repositoryId);
            if (ps == null) break block12;
            ps.close();
        }
        return null;
    }

    private void setRepositoryAttributes(Connection connection, String repositoryId, byte[] attributes) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement ps = connection.prepareStatement(UPDATE_REPOSITORY_ATTRIBUTES);){
            if (this.isH2(connection)) {
                ps.setBytes(1, attributes);
            } else {
                ps.setString(1, new String(attributes, StandardCharsets.UTF_8));
            }
            ps.setString(2, repositoryId);
            ps.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

