/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.search;

import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.search.DefaultComponentFinder;
import org.sonatype.nexus.repository.maven.internal.search.Maven2SearchResultComponentGenerator;

@Singleton
@Named(value="maven2")
public class Maven2ComponentFinder
extends DefaultComponentFinder {
    public static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");

    public Stream<FluentComponent> findComponentsByModel(Repository repository, String searchComponentId, String namespace, String name, String version) {
        if (Maven2SearchResultComponentGenerator.isSnapshotId(searchComponentId)) {
            FluentComponents components = this.contentFacet(repository).components();
            FluentComponentBuilder builder = components.name(name).namespace(namespace);
            String versionPrefix = version.replace("SNAPSHOT", "");
            return components.versions(namespace, name).stream().filter(v -> v.startsWith(versionPrefix)).filter(v -> SNAPSHOT_TIMESTAMP.matcher((CharSequence)v).matches()).sorted(Comparator.reverseOrder()).map(v -> builder.version(v).find()).filter(Optional::isPresent).map(Optional::get);
        }
        return super.findComponentsByModel(repository, searchComponentId, namespace, name, version);
    }
}

