/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.content.maven.internal.index.MavenContentProxyIndexFacet;
import org.sonatype.nexus.content.maven.internal.recipe.MavenMaintenanceFacet;
import org.sonatype.nexus.content.maven.internal.recipe.MavenProxyFacet;
import org.sonatype.nexus.content.maven.internal.recipe.MavenRecipeSupport;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.cache.NegativeCacheHandler;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.maven.RemoveSnapshotsFacet;
import org.sonatype.nexus.repository.maven.internal.matcher.MavenNx2MetaFilesMatcher;
import org.sonatype.nexus.repository.maven.internal.recipes.Maven2ProxyRecipe;
import org.sonatype.nexus.repository.proxy.ProxyHandler;
import org.sonatype.nexus.repository.purge.PurgeUnusedFacet;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named(value="maven2-proxy")
@Singleton
public class MavenProxyRecipe
extends MavenRecipeSupport
implements Maven2ProxyRecipe {
    private final Provider<HttpClientFacet> httpClientFacet;
    private final Provider<NegativeCacheFacet> negativeCacheFacet;
    private final Provider<MavenProxyFacet> proxyFacet;
    private final Provider<PurgeUnusedFacet> purgeUnusedFacet;
    private final Provider<RemoveSnapshotsFacet> removeSnapshotsFacet;
    private final NegativeCacheHandler negativeCacheHandler;
    private final ProxyHandler proxyHandler;
    private final Provider<MavenContentProxyIndexFacet> mavenProxyIndexFacet;
    private final Provider<MavenMaintenanceFacet> mavenMaintenanceFacet;

    @Inject
    public MavenProxyRecipe(@Named(value="proxy") Type type, @Named(value="maven2") Format format, Provider<HttpClientFacet> httpClientFacet, Provider<NegativeCacheFacet> negativeCacheFacet, Provider<MavenProxyFacet> proxyFacet, Provider<PurgeUnusedFacet> purgeUnusedFacet, NegativeCacheHandler negativeCacheHandler, ProxyHandler proxyHandler, Provider<MavenContentProxyIndexFacet> mavenProxyIndexFacet, Provider<MavenMaintenanceFacet> mavenMaintenanceFacet, Provider<RemoveSnapshotsFacet> removeSnapshotsFacet) {
        super(type, format);
        this.httpClientFacet = (Provider)Preconditions.checkNotNull(httpClientFacet);
        this.negativeCacheFacet = (Provider)Preconditions.checkNotNull(negativeCacheFacet);
        this.proxyFacet = (Provider)Preconditions.checkNotNull(proxyFacet);
        this.purgeUnusedFacet = (Provider)Preconditions.checkNotNull(purgeUnusedFacet);
        this.negativeCacheHandler = (NegativeCacheHandler)Preconditions.checkNotNull((Object)negativeCacheHandler);
        this.proxyHandler = (ProxyHandler)Preconditions.checkNotNull((Object)proxyHandler);
        this.mavenProxyIndexFacet = (Provider)Preconditions.checkNotNull(mavenProxyIndexFacet);
        this.mavenMaintenanceFacet = (Provider)Preconditions.checkNotNull(mavenMaintenanceFacet);
        this.removeSnapshotsFacet = (Provider)Preconditions.checkNotNull(removeSnapshotsFacet);
    }

    public void apply(@Nonnull Repository repository) throws Exception {
        repository.attach((Facet)this.getSecurityFacet().get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.getViewFacet().get()));
        repository.attach((Facet)this.httpClientFacet.get());
        repository.attach((Facet)this.negativeCacheFacet.get());
        repository.attach((Facet)this.proxyFacet.get());
        repository.attach((Facet)this.getMavenContentFacet().get());
        repository.attach((Facet)this.purgeUnusedFacet.get());
        repository.attach((Facet)this.getSearchFacet().get());
        repository.attach((Facet)this.getBrowseFacet().get());
        repository.attach((Facet)this.mavenProxyIndexFacet.get());
        repository.attach((Facet)this.mavenMaintenanceFacet.get());
        repository.attach((Facet)this.removeSnapshotsFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        builder.route(this.newMetadataRouteBuilder().handler((Handler)this.negativeCacheHandler).handler((Handler)this.getVersionPolicyHandler()).handler((Handler)this.getContentHeadersHandler()).handler((Handler)this.getLastDownloadedHandler()).handler((Handler)this.proxyHandler).create());
        builder.route(this.newIndexRouteBuilder().handler((Handler)this.negativeCacheHandler).handler((Handler)this.getPartialFetchHandler()).handler((Handler)this.getContentHeadersHandler()).handler((Handler)this.getLastDownloadedHandler()).handler((Handler)this.proxyHandler).create());
        builder.route(this.newArchetypeCatalogRouteBuilder().handler((Handler)this.negativeCacheHandler).handler((Handler)this.getPartialFetchHandler()).handler((Handler)this.getContentHeadersHandler()).handler((Handler)this.getLastDownloadedHandler()).handler((Handler)this.proxyHandler).create());
        builder.route(this.newNx2MetaFilesRouteBuilder().handler(HttpHandlers.notFound()).create());
        builder.route(this.newMavenPathRouteBuilder().handler((Handler)this.negativeCacheHandler).handler((Handler)this.getPartialFetchHandler()).handler((Handler)this.getVersionPolicyHandler()).handler((Handler)this.getContentHeadersHandler()).handler((Handler)this.getLastDownloadedHandler()).handler((Handler)this.proxyHandler).create());
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }

    Route.Builder newNx2MetaFilesRouteBuilder() {
        return new Route.Builder().matcher((Matcher)new MavenNx2MetaFilesMatcher(this.getMavenPathParser()));
    }
}

