/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.maven.MavenMetadataRebuildFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataRebuilder;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Payload;

@Named
public class MavenMetadataRebuildFacetImpl
extends FacetSupport
implements MavenMetadataRebuildFacet {
    private MavenContentFacet mavenContentFacet;
    private MetadataRebuilder metadataRebuilder;
    private static final ThreadLocal<Boolean> rebuilding = new ThreadLocal();

    @Inject
    public MavenMetadataRebuildFacetImpl(MetadataRebuilder metadataRebuilder) {
        this.metadataRebuilder = (MetadataRebuilder)Preconditions.checkNotNull((Object)metadataRebuilder);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.mavenContentFacet = (MavenContentFacet)this.facet(MavenContentFacet.class);
    }

    @Override
    public void maybeRebuildMavenMetadata(String path, boolean update, boolean rebuildChecksums) throws IOException {
        Optional maybeAsset = this.mavenContentFacet.assets().path(path).find();
        Optional<Payload> maybePayload = maybeAsset.map(FluentAsset::download);
        if (maybeAsset.isPresent() && maybePayload.isPresent()) {
            FluentAsset asset = (FluentAsset)maybeAsset.get();
            Payload payload = maybePayload.get();
            if (this.needsRebuild(this.mavenContentFacet.getMavenPathParser().parsePath(path), asset)) {
                asset.withoutAttribute("metadataRebuild");
                this.rebuildMetadata(payload, update, rebuildChecksums);
            }
        }
    }

    private boolean needsRebuild(MavenPath path, FluentAsset asset) {
        return !Boolean.TRUE.equals(rebuilding.get()) && path.getFileName().equals("maven-metadata.xml") && !(this.getRepository().getType() instanceof ProxyType) && Boolean.TRUE.equals(asset.attributes("metadataRebuild").get("forceRebuild", (Object)false));
    }

    private void rebuildMetadata(Payload metadataPayload, boolean update, boolean rebuildChecksums) throws IOException {
        Metadata metadata = MavenModels.readMetadata(metadataPayload.openInputStream());
        String groupId = Optional.ofNullable(metadata).map(Metadata::getGroupId).orElse(null);
        String artifactId = Optional.ofNullable(metadata).map(Metadata::getArtifactId).orElse(null);
        String baseVersion = Optional.ofNullable(metadata).map(Metadata::getVersion).orElse(null);
        this.rebuildMetadata(groupId, artifactId, baseVersion, rebuildChecksums, update);
    }

    @Override
    public void rebuildMetadata(String groupId, String artifactId, String baseVersion, boolean rebuildChecksums) {
        boolean update = !Strings.isNullOrEmpty((String)groupId) || !Strings.isNullOrEmpty((String)artifactId) || !Strings.isNullOrEmpty((String)baseVersion);
        this.rebuildMetadata(groupId, artifactId, baseVersion, rebuildChecksums, update);
    }

    @Override
    public void rebuildMetadata(String groupId, String artifactId, String baseVersion, boolean rebuildChecksums, boolean update) {
        rebuilding.set(Boolean.TRUE);
        try {
            this.metadataRebuilder.rebuildInTransaction(this.getRepository(), update, rebuildChecksums, groupId, artifactId, baseVersion);
        }
        finally {
            rebuilding.remove();
        }
    }
}

