/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.maven.LayoutPolicy;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class MavenContentHandler
extends ComponentSupport
implements Handler {
    public Response handle(@Nonnull Context context) throws Exception {
        MavenPath mavenPath = this.contentPath(context);
        String path = mavenPath.getPath();
        String method = context.getRequest().getAction();
        Repository repository = context.getRepository();
        this.log.debug("{} repository '{}' content-path: {}", new Object[]{method, repository.getName(), path});
        MavenContentFacet storage = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        switch (method) {
            case "GET": 
            case "HEAD": {
                return this.doGet(mavenPath, storage);
            }
            case "PUT": {
                this.doPut(context, mavenPath, storage);
                return HttpResponses.created();
            }
            case "DELETE": {
                return this.doDelete(mavenPath, storage);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "PUT", "DELETE"});
    }

    private MavenPath contentPath(@Nonnull Context context) {
        return (MavenPath)context.getAttributes().require(MavenPath.class);
    }

    private Response doGet(MavenPath mavenPath, MavenContentFacet storage) throws IOException {
        return storage.get(mavenPath).map(HttpResponses::ok).orElseGet(() -> HttpResponses.notFound((String)mavenPath.getPath()));
    }

    private void doPut(@Nonnull Context context, MavenPath mavenPath, MavenContentFacet storage) throws IOException {
        this.validatePathForStrictLayoutPolicy(mavenPath, storage);
        storage.put(mavenPath, context.getRequest().getPayload());
    }

    private void validatePathForStrictLayoutPolicy(MavenPath mavenPath, MavenContentFacet storage) {
        if (storage.layoutPolicy() == LayoutPolicy.STRICT && this.isValidSnapshot(mavenPath.getCoordinates()) && !storage.getMavenPathParser().isRepositoryMetadata(mavenPath)) {
            throw new IllegalOperationException(" Invalid mavenPath for a Maven 2 repository");
        }
    }

    private Response doDelete(MavenPath mavenPath, MavenContentFacet storage) throws IOException {
        boolean deleted = storage.delete(mavenPath);
        if (deleted) {
            return HttpResponses.noContent();
        }
        return HttpResponses.notFound((String)mavenPath.getPath());
    }

    private boolean isValidSnapshot(MavenPath.Coordinates coordinates) {
        return coordinates == null || coordinates.isSnapshot() && !coordinates.getVersion().equals(coordinates.getBaseVersion()) && (coordinates.getTimestamp() == null || coordinates.getBuildNumber() == null);
    }
}

