/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.content.maven.internal.event.RebuildMavenArchetypeCatalogEvent;
import org.sonatype.nexus.content.maven.internal.recipe.MavenAttributesHelper;
import org.sonatype.nexus.content.maven.store.GAV;
import org.sonatype.nexus.content.maven.store.Maven2AssetStore;
import org.sonatype.nexus.content.maven.store.Maven2ComponentData;
import org.sonatype.nexus.content.maven.store.Maven2ComponentStore;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.maven.LayoutPolicy;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.Attributes;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataRebuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.repository.maven.internal.validation.MavenMetadataContentValidator;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="maven2")
public class MavenContentFacetImpl
extends ContentFacetSupport
implements MavenContentFacet {
    private static final char ASSET_PATH_PREFIX = '/';
    private static final String CONFIG_KEY = "maven";
    private final Map<String, MavenPathParser> mavenPathParsers;
    private final MavenMetadataContentValidator metadataValidator;
    private final EventManager eventManager;
    private final boolean metadataValidationEnabled;
    private Config config;
    private MavenPathParser mavenPathParser;
    private MetadataRebuilder metadataRebuilder;

    @Inject
    public MavenContentFacetImpl(@Named(value="maven2") FormatStoreManager formatStoreManager, Map<String, MavenPathParser> mavenPathParsers, MetadataRebuilder metadataRebuilder, MavenMetadataContentValidator metadataValidator, EventManager eventManager, @Named(value="${nexus.maven.metadata.validation.enabled:-true}") boolean metadataValidationEnabled) {
        super(formatStoreManager);
        this.mavenPathParsers = (Map)Preconditions.checkNotNull(mavenPathParsers);
        this.metadataRebuilder = (MetadataRebuilder)Preconditions.checkNotNull((Object)metadataRebuilder);
        this.metadataValidator = metadataValidator;
        this.eventManager = eventManager;
        this.metadataValidationEnabled = metadataValidationEnabled;
    }

    @Override
    public MavenPathParser getMavenPathParser() {
        return this.mavenPathParser;
    }

    @Override
    public LayoutPolicy layoutPolicy() {
        return this.config.layoutPolicy;
    }

    @Override
    public VersionPolicy getVersionPolicy() {
        return this.config.versionPolicy;
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)this.mavenPathParsers.get(this.getRepository().getFormat().getValue()));
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        super.doConfigure(configuration);
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected WritePolicy writePolicy(Asset asset) {
        WritePolicy configuredWritePolicy = super.writePolicy(asset);
        if (WritePolicy.ALLOW_ONCE == configuredWritePolicy) {
            String assetKind = asset.kind();
            if (StringUtils.equals((CharSequence)Attributes.AssetKind.REPOSITORY_METADATA.name(), (CharSequence)assetKind) || StringUtils.equals((CharSequence)Attributes.AssetKind.REPOSITORY_INDEX.name(), (CharSequence)assetKind) || StringUtils.equals((CharSequence)Attributes.AssetKind.ARTIFACT_SUBORDINATE.name(), (CharSequence)assetKind)) {
                return WritePolicy.ALLOW;
            }
        }
        return configuredWritePolicy;
    }

    @Override
    public Optional<Content> get(MavenPath mavenPath) {
        this.log.debug("GET {} : {}", (Object)this.getRepository().getName(), (Object)mavenPath);
        return this.findAsset(this.assetPath(mavenPath)).map(FluentAsset::download);
    }

    @Override
    public Content put(MavenPath mavenPath, Payload content) throws IOException {
        this.log.debug("PUT {} : {}", (Object)this.getRepository().getName(), (Object)mavenPath);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.blobs().ingest(content, MavenPath.HashType.ALGORITHMS);){
            if (this.isMetadataAndValidationEnabled(mavenPath)) {
                this.validate(mavenPath, blob);
            }
            return this.save(mavenPath, content, blob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Optional<FluentAsset> findAsset(String path) {
        return this.assets().path(path).find();
    }

    private boolean isMetadataAndValidationEnabled(MavenPath mavenPath) {
        return mavenPath.getFileName().equals("maven-metadata.xml") && this.metadataValidationEnabled;
    }

    private void validate(MavenPath mavenPath, TempBlob blob) {
        this.log.debug("Validating maven-metadata.xml before storing");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = blob.get();){
                this.metadataValidator.validate(mavenPath.getPath(), in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Content save(MavenPath mavenPath, Payload content, TempBlob blob) throws IOException {
        FluentComponent component = null;
        if (mavenPath.getCoordinates() != null) {
            Optional<Model> model = this.maybeReadMavenModel(mavenPath, blob);
            component = this.createOrGetComponent(mavenPath, model);
        }
        return this.saveAsset(mavenPath, (Component)component, content, blob);
    }

    private FluentComponent createOrGetComponent(MavenPath mavenPath, Optional<Model> model) {
        Optional<String> optionalKind = model.map(MavenAttributesHelper::getPackaging);
        MavenPath.Coordinates coordinates = mavenPath.getCoordinates();
        FluentComponent component = this.components().name(coordinates.getArtifactId()).namespace(coordinates.getGroupId()).version(coordinates.getVersion()).kind(optionalKind).getOrCreate();
        boolean isNew = this.isNewRepositoryContent((RepositoryContent)component);
        MavenAttributesHelper.setMavenAttributes((Maven2ComponentStore)this.stores().componentStore, component, coordinates, model, this.contentRepositoryId());
        if (isNew) {
            this.publishEvents(component);
        } else {
            optionalKind.ifPresent(arg_0 -> ((FluentComponent)component).kind(arg_0));
        }
        return component;
    }

    private boolean isNewRepositoryContent(RepositoryContent repositoryContent) {
        return repositoryContent.attributes().isEmpty();
    }

    @Override
    public void maybeUpdateComponentAttributes(MavenPath mavenPath) throws IOException {
        Optional optAsset;
        if (mavenPath.isPom() && (optAsset = this.assets().path(this.assetPath(mavenPath)).find()).isPresent()) {
            FluentAsset asset = (FluentAsset)optAsset.get();
            Model model = MavenModels.readModel(asset.download().openInputStream());
            this.createOrGetComponent(mavenPath, Optional.ofNullable(model));
        }
    }

    private void publishEvents(FluentComponent component) {
        if ("maven-archetype".equals(component.kind())) {
            this.eventManager.post((Object)new RebuildMavenArchetypeCatalogEvent(this.getRepository().getName()));
        }
    }

    private Optional<Model> maybeReadMavenModel(MavenPath mavenPath, TempBlob blob) throws IOException {
        Model model = null;
        if (mavenPath.isPom() && (model = MavenModels.readModel(blob.getBlob().getInputStream())) == null) {
            this.log.warn("Could not parse POM: {} @ {}", (Object)this.getRepository().getName(), (Object)this.assetPath(mavenPath));
        }
        return Optional.ofNullable(model);
    }

    private Content saveAsset(MavenPath mavenPath, Component component, Payload content, TempBlob blob) {
        FluentAsset asset;
        String path = this.assetPath(mavenPath);
        FluentAssetBuilder assetBuilder = this.assets().path(path).kind(MavenAttributesHelper.assetKind(mavenPath, this.mavenPathParser));
        if (component != null) {
            assetBuilder = assetBuilder.component(component);
        }
        if (this.isNewRepositoryContent((RepositoryContent)(asset = assetBuilder.blob(blob).save()))) {
            MavenAttributesHelper.setMavenAttributes(asset, mavenPath);
        }
        return asset.markAsCached(content).download();
    }

    private String assetPath(MavenPath mavenPath) {
        return String.valueOf('/') + mavenPath.getPath();
    }

    @Override
    public boolean delete(MavenPath mavenPath) {
        this.log.trace("DELETE {} : {}", (Object)this.getRepository().getName(), (Object)mavenPath);
        boolean assetIsDeleted = this.deleteAsset(mavenPath);
        if (assetIsDeleted && mavenPath.getCoordinates() != null) {
            this.maybeDeleteComponent(mavenPath.getCoordinates());
        }
        return assetIsDeleted;
    }

    @Override
    public boolean delete(List<String> paths) {
        Repository repository = this.getRepository();
        this.log.trace("DELETE {} assets at {}", (Object)repository.getName(), paths);
        return this.stores().assetStore.deleteAssetsByPaths(this.contentRepositoryId().intValue(), paths) > 0;
    }

    @Override
    public Set<String> deleteWithHashes(MavenPath mavenPath) {
        HashSet<String> paths = new HashSet<String>(MavenPath.HashType.values().length + 1);
        if (this.delete(mavenPath.main())) {
            paths.add(mavenPath.main().getPath());
        }
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            MavenPath hashMavenPath = mavenPath.main().hash(hashType);
            if (this.delete(hashMavenPath)) {
                paths.add(hashMavenPath.getPath());
            }
            ++n2;
        }
        return paths;
    }

    @Override
    public boolean exists(MavenPath mavenPath) {
        return this.findAsset(this.assetPath(mavenPath)).isPresent();
    }

    private boolean deleteAsset(MavenPath mavenPath) {
        return this.findAsset(this.assetPath(mavenPath)).map(FluentAsset::delete).orElse(false);
    }

    private void maybeDeleteComponent(MavenPath.Coordinates coordinates) {
        this.components().name(coordinates.getArtifactId()).namespace(coordinates.getGroupId()).version(coordinates.getVersion()).find().ifPresent(this::deleteIfNoAssetsLeft);
    }

    private void deleteIfNoAssetsLeft(FluentComponent component) {
        if (component.assets().isEmpty()) {
            component.delete();
            this.publishEvents(component);
            this.deleteMetadataOrFlagForRebuild((Component)component);
        }
    }

    @Override
    public int deleteComponents(int[] componentIds) {
        ContentFacetSupport contentFacet = (ContentFacetSupport)this.facet(ContentFacet.class);
        ComponentStore componentStore = contentFacet.stores().componentStore;
        if (!"proxy".equals(this.repository().getType().getValue())) {
            Set<List<String>> gavs = this.collectGavs(componentIds);
            int deletedCount = componentStore.purge(contentFacet.contentRepositoryId().intValue(), componentIds);
            gavs.forEach(gav -> {
                Set<String> set = this.deleteMetadataOrFlagForRebuild((String)gav.get(0), (String)gav.get(1), (String)gav.get(2));
            });
            return deletedCount;
        }
        return componentStore.purge(contentFacet.contentRepositoryId().intValue(), componentIds);
    }

    private Set<List<String>> collectGavs(int[] componentIds) {
        ContentFacetSupport contentFacet = (ContentFacetSupport)this.facet(ContentFacet.class);
        ComponentStore componentStore = contentFacet.stores().componentStore;
        return Arrays.stream(componentIds).mapToObj(arg_0 -> ((ComponentStore)componentStore).readComponent(arg_0)).filter(Optional::isPresent).map(Optional::get).map(this::collectGabv).map(stringArray -> Arrays.asList(stringArray)).collect(Collectors.toSet());
    }

    private String[] collectGabv(Component component) {
        return new String[]{component.namespace(), component.name(), (String)component.attributes("maven2").get("baseVersion", String.class)};
    }

    @Override
    public Set<String> deleteMetadataOrFlagForRebuild(Component component) {
        if (!"proxy".equals(this.repository().getType().getValue())) {
            String[] gav = this.collectGabv(component);
            return this.deleteMetadataOrFlagForRebuild(gav[0], gav[1], gav[2]);
        }
        return Collections.emptySet();
    }

    private Set<String> deleteMetadataOrFlagForRebuild(String groupId, String artifactId, String baseVersion) {
        boolean gabvNonEmpty;
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)artifactId);
        Preconditions.checkNotNull((Object)baseVersion);
        ArrayList<String[]> metadataCoordinatesToDelete = new ArrayList<String[]>();
        ImmutableMap gabvQueryParameters = ImmutableMap.of((Object)"groupId", (Object)groupId, (Object)"artifactId", (Object)artifactId, (Object)"baseVersion", (Object)baseVersion);
        boolean gNonEmpty = this.components().byFilter("namespace = #{filterParams.groupId}", (Map)gabvQueryParameters).count() > 0;
        boolean gaNonEmpty = gNonEmpty && this.components().byFilter("namespace = #{filterParams.groupId} AND name = #{filterParams.artifactId}", (Map)gabvQueryParameters).count() > 0;
        boolean bl = gabvNonEmpty = gaNonEmpty && this.components().byFilter("namespace = #{filterParams.groupId} AND name = #{filterParams.artifactId} AND base_version = #{filterParams.baseVersion}", (Map)gabvQueryParameters).count() > 0;
        if (gabvNonEmpty) {
            this.flagForMetadataRebuild(groupId, artifactId, baseVersion);
        } else if (gaNonEmpty) {
            metadataCoordinatesToDelete.add(new String[]{groupId, artifactId, baseVersion});
            this.flagForMetadataRebuild(groupId, artifactId, null);
        } else if (gNonEmpty) {
            metadataCoordinatesToDelete.add(new String[]{groupId, artifactId, baseVersion});
            String[] stringArray = new String[3];
            stringArray[0] = groupId;
            stringArray[1] = artifactId;
            metadataCoordinatesToDelete.add(stringArray);
            this.flagForMetadataRebuild(groupId, null, null);
        } else {
            metadataCoordinatesToDelete.add(new String[]{groupId, artifactId, baseVersion});
            String[] stringArray = new String[3];
            stringArray[0] = groupId;
            stringArray[1] = artifactId;
            metadataCoordinatesToDelete.add(stringArray);
            String[] stringArray2 = new String[3];
            stringArray2[0] = groupId;
            metadataCoordinatesToDelete.add(stringArray2);
        }
        return this.metadataRebuilder.deleteMetadata(this.getRepository(), metadataCoordinatesToDelete);
    }

    private void flagForMetadataRebuild(String groupId, String artifactId, String baseVersion) {
        this.assets().path(StringUtils.prependIfMissing((String)MetadataUtils.metadataPath(groupId, artifactId, baseVersion).getPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0])).find().ifPresent(this::setMetadataRebuildFlag);
    }

    private void setMetadataRebuildFlag(FluentAsset asset) {
        HashMap<String, Boolean> metadataRebuild = new HashMap<String, Boolean>();
        metadataRebuild.put("forceRebuild", true);
        asset.withAttribute("metadataRebuild", metadataRebuild);
    }

    @Override
    public Set<GAV> findGavsWithSnaphots(int minimumRetained) {
        Maven2ComponentStore componentStore = (Maven2ComponentStore)this.stores().componentStore;
        return componentStore.findGavsWithSnaphots(this.contentRepositoryId(), minimumRetained);
    }

    @Override
    public List<Maven2ComponentData> findComponentsForGav(String name, String group, String baseVersion, String releaseVersion) {
        Maven2ComponentStore componentStore = (Maven2ComponentStore)this.stores().componentStore;
        return componentStore.findComponentsForGav(this.contentRepositoryId(), name, group, baseVersion, releaseVersion);
    }

    @Override
    public Continuation<FluentComponent> findComponentsInGA(int limit, @Nullable String continuationToken, String namespace, String name) {
        ImmutableMap filterParams = ImmutableMap.of((Object)"groupId", (Object)namespace, (Object)"artifactId", (Object)name);
        return this.components().byFilter("namespace = #{filterParams.groupId} AND name = #{filterParams.artifactId}", (Map)filterParams).browse(limit, continuationToken);
    }

    @Override
    public int[] selectSnapshotsAfterRelease(int gracePeriod) {
        Maven2ComponentStore componentStore = (Maven2ComponentStore)this.stores().componentStore;
        return componentStore.selectSnapshotsAfterRelease(gracePeriod, this.contentRepositoryId());
    }

    @Override
    public FluentAsset createComponentAndAsset(MavenPath mavenPath) {
        String assetName = "/" + mavenPath.getPath();
        String assetKind = MavenAttributesHelper.assetKind(mavenPath, this.mavenPathParser);
        if (mavenPath.getCoordinates() == null) {
            return this.assets().path(assetName).kind(assetKind).save();
        }
        MavenPath.Coordinates coordinates = (MavenPath.Coordinates)Preconditions.checkNotNull((Object)mavenPath.getCoordinates());
        FluentComponent component = this.createOrGetComponent(coordinates);
        FluentAsset asset = component.asset(assetName).kind(assetKind).save();
        this.configureAssetAttributes(asset, coordinates);
        return asset;
    }

    @Override
    public FluentComponent copy(Component source) {
        FluentComponentBuilder componentBuilder = this.components().name(source.name()).namespace(source.namespace()).version(source.version());
        source.attributes().forEach(attribute -> componentBuilder.attributes((String)attribute.getKey(), attribute.getValue()));
        FluentComponent component = componentBuilder.getOrCreate();
        Maven2ComponentData componentData = new Maven2ComponentData();
        componentData.setNamespace(source.namespace());
        componentData.setName(source.name());
        componentData.setVersion(source.version());
        componentData.setRepositoryId(this.contentRepositoryId());
        componentData.setBaseVersion(component.attributes().child("maven2").get("baseVersion").toString());
        Maven2ComponentStore componentStore = (Maven2ComponentStore)this.stores().componentStore;
        componentStore.updateBaseVersion(componentData);
        return component;
    }

    @Override
    public Continuation<Asset> findMavenPluginAssetsForNamespace(int limit, @Nullable String continuationToken, String namespace) {
        return ((Maven2AssetStore)this.stores().assetStore).findMavenPluginAssetsForNamespace(this.contentRepositoryId(), limit, continuationToken, namespace);
    }

    @Override
    public Collection<String> getBaseVersions(String namespace, String name) {
        return ((Maven2ComponentStore)this.stores().componentStore).getBaseVersions(this.contentRepositoryId(), namespace, name);
    }

    @Override
    public Continuation<FluentComponent> findComponentsForBaseVersion(int limit, @Nullable String continuationToken, String namespace, String name, String baseVersion) {
        ImmutableMap filterParams = ImmutableMap.of((Object)"groupId", (Object)namespace, (Object)"artifactId", (Object)name, (Object)"baseVersion", (Object)baseVersion);
        return this.components().byFilter("namespace = #{filterParams.groupId} AND name = #{filterParams.artifactId} AND base_version = #{filterParams.baseVersion}", (Map)filterParams).browse(limit, continuationToken);
    }

    private FluentComponent createOrGetComponent(MavenPath.Coordinates coordinates) {
        MavenContentFacet facet = (MavenContentFacet)this.getRepository().facet(MavenContentFacet.class);
        String artifactId = coordinates.getArtifactId();
        String groupId = coordinates.getGroupId();
        String version = coordinates.getVersion();
        String baseVersion = coordinates.getBaseVersion();
        FluentComponent component = facet.components().name(artifactId).namespace(groupId).version(version).getOrCreate();
        ImmutableMap.Builder componentAttributes = ImmutableMap.builder();
        componentAttributes.put((Object)"groupId", (Object)groupId);
        componentAttributes.put((Object)"artifactId", (Object)artifactId);
        componentAttributes.put((Object)"version", (Object)version);
        componentAttributes.put((Object)"baseVersion", (Object)baseVersion);
        component.attributes(AttributeOperation.OVERLAY, "maven2", (Object)componentAttributes.build());
        Maven2ComponentData componentData = new Maven2ComponentData();
        componentData.setNamespace(groupId);
        componentData.setName(artifactId);
        componentData.setVersion(version);
        componentData.setRepositoryId(facet.contentRepositoryId());
        componentData.setBaseVersion(baseVersion);
        Maven2ComponentStore componentStore = (Maven2ComponentStore)this.stores().componentStore;
        componentStore.updateBaseVersion(componentData);
        return component;
    }

    private void configureAssetAttributes(FluentAsset asset, MavenPath.Coordinates coordinates) {
        ImmutableMap.Builder assetAttributes = ImmutableMap.builder();
        assetAttributes.put((Object)"groupId", (Object)coordinates.getGroupId());
        assetAttributes.put((Object)"artifactId", (Object)coordinates.getArtifactId());
        assetAttributes.put((Object)"version", (Object)coordinates.getVersion());
        assetAttributes.put((Object)"baseVersion", (Object)coordinates.getBaseVersion());
        if (coordinates.getClassifier() != null) {
            assetAttributes.put((Object)"classifier", (Object)coordinates.getClassifier());
        }
        assetAttributes.put((Object)"extension", (Object)coordinates.getExtension());
        asset.attributes(AttributeOperation.OVERLAY, "maven2", (Object)assetAttributes.build());
    }

    static class Config {
        @NotNull(groups={HostedType.ValidationGroup.class, ProxyType.ValidationGroup.class})
        public VersionPolicy versionPolicy;
        @NotNull(groups={HostedType.ValidationGroup.class, ProxyType.ValidationGroup.class})
        public LayoutPolicy layoutPolicy;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "versionPolicy=" + (Object)((Object)this.versionPolicy) + ", layoutPolicy=" + (Object)((Object)this.layoutPolicy) + '}';
        }
    }
}

