/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import com.google.common.collect.Iterables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.content.maven.MavenArchetypeCatalogFacet;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.content.maven.internal.event.RebuildMavenArchetypeCatalogEvent;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.utils.HashedPayload;
import org.sonatype.nexus.repository.maven.internal.utils.MavenIOUtils;
import org.sonatype.nexus.repository.view.Payload;

@Named
public class MavenArchetypeCatalogFacetImpl
extends FacetSupport
implements MavenArchetypeCatalogFacet {
    private static final String HOSTED_ARCHETYPE_CATALOG = "hosted-archetype-catalog";
    private static final String XML = "xml";
    public static final String MAVEN_ARCHETYPE_KIND = "maven-archetype";
    private static final String ARCHETYPE_CATALOG_PATH = "/archetype-catalog.xml";
    private MavenPath archetypeCatalogMavenPath;
    private MavenContentFacet mavenContentFacet;
    private final int componentPageSize;

    @Inject
    public MavenArchetypeCatalogFacetImpl(@Named(value="${maven.archetypes.page.size:-10}") int componentPageSize) {
        this.componentPageSize = componentPageSize;
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.mavenContentFacet = (MavenContentFacet)this.facet(MavenContentFacet.class);
        this.archetypeCatalogMavenPath = this.mavenContentFacet.getMavenPathParser().parsePath(ARCHETYPE_CATALOG_PATH);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RebuildMavenArchetypeCatalogEvent event) throws IOException {
        if (StringUtils.equals((String)this.getRepository().getName(), (String)event.getRepositoryName())) {
            this.deleteExistingCatalog();
        }
    }

    @Override
    public void rebuildArchetypeCatalog() throws IOException {
        this.deleteExistingCatalog();
        this.log.debug("Rebuilding hosted archetype catalog for {}", (Object)this.getRepository().getName());
        Path path = Files.createTempFile(HOSTED_ARCHETYPE_CATALOG, XML, new FileAttribute[0]);
        ArchetypeCatalog hostedCatalog = this.createArchetypeCatalog();
        try {
            HashedPayload hashedPayload = this.createArchetypeCatalogFile(hostedCatalog, path);
            Throwable throwable = null;
            Object var5_6 = null;
            try (Payload payload = hashedPayload.getPayload();){
                this.mavenContentFacet.put(this.archetypeCatalogMavenPath, payload);
                this.putHashedContent(this.archetypeCatalogMavenPath, hashedPayload);
                this.log.trace("Rebuilt hosted archetype catalog for {} with {} archetype", (Object)this.getRepository().getName(), (Object)hostedCatalog.getArchetypes().size());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            Files.delete(path);
        }
    }

    private void deleteExistingCatalog() throws IOException {
        this.mavenContentFacet.delete(this.archetypeCatalogMavenPath);
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            this.mavenContentFacet.delete(this.archetypeCatalogMavenPath.main().hash(hashType));
            ++n2;
        }
    }

    private void putHashedContent(MavenPath mavenPath, HashedPayload hashedPayload) throws IOException {
        Map<HashAlgorithm, HashCode> hashCodes = hashedPayload.getHashCodes();
        for (Map.Entry<MavenPath.HashType, Payload> entry : MavenIOUtils.hashesToPayloads(hashCodes).entrySet()) {
            this.mavenContentFacet.put(mavenPath.hash(entry.getKey()), entry.getValue());
        }
    }

    private ArchetypeCatalog createArchetypeCatalog() {
        ArchetypeCatalog hostedCatalog = new ArchetypeCatalog();
        Iterables.addAll((Collection)hostedCatalog.getArchetypes(), this.getArchetypes());
        return hostedCatalog;
    }

    private HashedPayload createArchetypeCatalogFile(ArchetypeCatalog hostedCatalog, Path path) throws IOException {
        return MavenIOUtils.createStreamPayload(path, "application/xml", outputStream -> MavenModels.writeArchetypeCatalog(outputStream, hostedCatalog));
    }

    private Iterable<Archetype> getArchetypes() {
        ArrayList<Archetype> archetypes = new ArrayList<Archetype>();
        FluentQuery archetypeQuery = this.mavenContentFacet.components().byKind(MAVEN_ARCHETYPE_KIND);
        Continuation components = archetypeQuery.browse(this.componentPageSize, null);
        while (!components.isEmpty()) {
            archetypes.addAll(components.stream().map(this::toArchetype).collect(Collectors.toList()));
            components = archetypeQuery.browse(this.componentPageSize, components.nextContinuationToken());
        }
        return archetypes;
    }

    private Archetype toArchetype(FluentComponent component) {
        Archetype archetype = new Archetype();
        archetype.setGroupId(component.namespace());
        archetype.setArtifactId(component.name());
        archetype.setVersion(component.version());
        return archetype;
    }
}

