/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.content.maven.internal.MavenPreReleaseEvaluator;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.search.DefaultSearchDocumentProducer;
import org.sonatype.nexus.repository.content.search.SearchDocumentExtension;
import org.sonatype.nexus.repository.maven.internal.search.MavenVersionNormalizer;

@Singleton
@Named(value="maven2")
public class MavenSearchDocumentProducer
extends DefaultSearchDocumentProducer {
    private final MavenVersionNormalizer versionNormalizer;
    private final MavenPreReleaseEvaluator preReleaseEvaluator;

    @Inject
    public MavenSearchDocumentProducer(Set<SearchDocumentExtension> documentExtensions, MavenVersionNormalizer versionNormalizer, MavenPreReleaseEvaluator preReleaseEvaluator) {
        super(documentExtensions);
        this.versionNormalizer = (MavenVersionNormalizer)((Object)Preconditions.checkNotNull((Object)((Object)versionNormalizer)));
        this.preReleaseEvaluator = (MavenPreReleaseEvaluator)Preconditions.checkNotNull((Object)preReleaseEvaluator);
    }

    protected boolean isPrerelease(FluentComponent component) {
        return this.preReleaseEvaluator.isPreRelease(component);
    }

    protected String getNormalizedVersion(FluentComponent component) {
        return this.versionNormalizer.getNormalizedValue(component.version());
    }
}

