/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class TempBlobPayload
implements Payload {
    private final String contentType;
    private final TempBlob tempBlob;

    public TempBlobPayload(TempBlob tempBlob, @Nullable String contentType) {
        this.tempBlob = (TempBlob)Preconditions.checkNotNull((Object)tempBlob);
        this.contentType = contentType;
    }

    public TempBlobPayload(TempBlob tempBlob) {
        this.tempBlob = (TempBlob)Preconditions.checkNotNull((Object)tempBlob);
        this.contentType = (String)tempBlob.getBlob().getHeaders().get("BlobStore.content-type");
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.tempBlob.get();
    }

    @Override
    public long getSize() {
        return this.tempBlob.getBlob().getMetrics().getContentSize();
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public <T extends TempBlob> T getTempBlob() {
        return (T)this.tempBlob;
    }

    @Override
    public void close() throws IOException {
        this.tempBlob.close();
    }
}

