/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.view.Payload;

public class DetachedBlobPayload
implements Payload {
    private final Blob blob;
    private final String contentType;

    public DetachedBlobPayload(Blob blob) {
        this.blob = (Blob)Preconditions.checkNotNull((Object)blob);
        this.contentType = (String)blob.getHeaders().get("BlobStore.content-type");
    }

    public Blob getBlob() {
        return this.blob;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.blob.getInputStream();
    }

    @Override
    public long getSize() {
        return this.blob.getMetrics().getContentSize();
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "blob=" + this.blob + ", contentType='" + this.contentType + '\'' + '}';
    }
}

