/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers.token;

import com.google.common.base.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.nexus.repository.view.matchers.token.Token;

public class VariableToken
extends Token {
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z0-9]");
    private final String name;
    private final String regexpGroupName;

    public VariableToken(String name, String regexp) {
        super(regexp);
        this.name = name;
        this.regexpGroupName = VariableToken.toRegexpGroupName(name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toRegexp() {
        return "(?<" + this.regexpGroupName + ">" + this.value + ")";
    }

    public String getRegexpGroupName() {
        return this.regexpGroupName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableToken)) {
            return false;
        }
        VariableToken other = (VariableToken)obj;
        return Objects.equal((Object)this.getName(), (Object)other.getName()) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.value});
    }

    public String toString() {
        return String.format("var(%s,%s)", this.name, this.value);
    }

    private static String toRegexpGroupName(String name) {
        StringBuilder sb = new StringBuilder();
        Matcher m = NAME_PATTERN.matcher(name);
        while (m.find()) {
            sb.append(m.group());
        }
        if (sb.length() == 0) {
            throw new IllegalStateException("Token name '" + name + "' contains no valid characters.");
        }
        if (Character.isDigit(sb.charAt(0))) {
            sb.insert(0, 'g');
        }
        return sb.toString();
    }
}

