/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers.token;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.matchers.token.PatternParser;
import org.sonatype.nexus.repository.view.matchers.token.Token;
import org.sonatype.nexus.repository.view.matchers.token.VariableToken;

public class TokenParser
extends ComponentSupport {
    private final List<VariableToken> variables;
    private final Pattern pattern;

    public TokenParser(String templatePattern) {
        List<Token> tokens = new PatternParser(templatePattern).getTokens();
        this.pattern = Pattern.compile(this.regexp(tokens));
        this.log.trace("Pattern: {}", (Object)this.pattern);
        this.variables = new ArrayList<VariableToken>();
        for (Token token : tokens) {
            if (!(token instanceof VariableToken)) continue;
            this.variables.add((VariableToken)token);
        }
    }

    @Nullable
    public Map<String, String> parse(String path) {
        Matcher matcher = this.pattern.matcher(path);
        if (!matcher.matches()) {
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (VariableToken variableToken : this.variables) {
            String name = variableToken.getName();
            String value = matcher.group(variableToken.getRegexpGroupName());
            if (values.containsKey(name)) {
                String existingValue = (String)values.get(name);
                if (Objects.equals(existingValue, value)) continue;
                this.log.trace("Variable '{}' values mismatch: '{}' vs '{}'", new Object[]{name, existingValue, value});
                return null;
            }
            values.put(name, value);
        }
        return values;
    }

    public String getPattern() {
        return this.pattern.toString();
    }

    private String regexp(List<Token> tokens) {
        StringBuilder b = new StringBuilder();
        HashSet<String> previous = new HashSet<String>();
        for (Token token : tokens) {
            if (token instanceof VariableToken) {
                VariableToken variable = (VariableToken)token;
                if (previous.contains(variable.getName())) {
                    b.append("\\k<" + variable.getRegexpGroupName() + ">");
                } else {
                    b.append(variable.toRegexp());
                }
                previous.add(variable.getName());
                continue;
            }
            b.append(token.toRegexp());
        }
        return b.toString();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "pattern=" + this.pattern + ", variables=" + this.variables + '}';
    }
}

