/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers.logic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;

public class OrMatcher
extends ComponentSupport
implements Matcher {
    private final List<Matcher> matchers;

    @VisibleForTesting
    public OrMatcher(List<Matcher> matchers) {
        this.matchers = (List)Preconditions.checkNotNull(matchers);
    }

    @Override
    public boolean matches(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Matching: {}", (Object)Joiner.on((String)" OR ").join(this.matchers));
        }
        for (Matcher matcher : this.matchers) {
            boolean matched = matcher.matches(context);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "matchers=" + this.matchers + '}';
    }
}

