/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;

public class SuffixMatcher
extends ComponentSupport
implements Matcher {
    private final String suffix;
    private final boolean ignoreCase;

    @VisibleForTesting
    public SuffixMatcher(String suffix, boolean ignoreCase) {
        this.suffix = (String)Preconditions.checkNotNull((Object)suffix);
        this.ignoreCase = ignoreCase;
    }

    public SuffixMatcher(String suffix) {
        this(suffix, false);
    }

    public SuffixMatcher ignoreCase(boolean ignoreCase) {
        return new SuffixMatcher(this.suffix, ignoreCase);
    }

    @Override
    public boolean matches(Context context) {
        Preconditions.checkNotNull((Object)context);
        String path = context.getRequest().getPath();
        this.log.debug("Matching: {} ends-with={} ignore-case: {}", new Object[]{path, this.suffix, this.ignoreCase});
        if (this.ignoreCase) {
            return Strings2.lower((String)path).endsWith(Strings2.lower((String)this.suffix));
        }
        return path.endsWith(this.suffix);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "suffix='" + this.suffix + '\'' + ", ignoreCase=" + this.ignoreCase + '}';
    }
}

