/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers;

import com.google.common.base.Preconditions;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;

public class RegexMatcher
extends ComponentSupport
implements Matcher {
    private final Pattern pattern;

    public RegexMatcher(Pattern pattern) {
        this.pattern = (Pattern)Preconditions.checkNotNull((Object)pattern);
    }

    public RegexMatcher(String regex, int flags) {
        Preconditions.checkNotNull((Object)regex);
        this.pattern = Pattern.compile(regex, flags);
    }

    public RegexMatcher(String regex) {
        Preconditions.checkNotNull((Object)regex);
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean matches(Context context) {
        Preconditions.checkNotNull((Object)context);
        String path = context.getRequest().getPath();
        this.log.debug("Matching: {}~={}", (Object)path, (Object)this.pattern);
        final java.util.regex.Matcher m = this.pattern.matcher(path);
        if (m.matches()) {
            context.getAttributes().set(State.class, (Object)new State(){

                @Override
                public MatchResult getMatchResult() {
                    return m;
                }
            });
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "pattern=" + this.pattern + '}';
    }

    public static interface State {
        public MatchResult getMatchResult();
    }
}

