/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;

@Named
@Singleton
public class HighAvailabilitySupportChecker {
    private final boolean isNexusClustered;
    private final Map<String, Boolean> formatHAStates = new ConcurrentHashMap<String, Boolean>();

    @Inject
    public HighAvailabilitySupportChecker(NodeAccess nodeAccess) {
        this.isNexusClustered = nodeAccess.isClustered();
    }

    public boolean isSupported(String formatName) {
        boolean formatForcedEnabled = this.formatHAStates.computeIfAbsent(formatName, f -> SystemPropertiesHelper.getBoolean((String)String.format("nexus.%s.ha.supported", formatName), (boolean)false));
        return !this.isNexusClustered || formatForcedEnabled;
    }
}

