/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.handlers.HighAvailabilitySupportChecker;

@Named
@Singleton
public class FormatHighAvailabilitySupportHandler
implements Handler {
    private HighAvailabilitySupportChecker highAvailabilitySupportChecker;

    @Inject
    public FormatHighAvailabilitySupportHandler(HighAvailabilitySupportChecker highAvailabilitySupportChecker) {
        this.highAvailabilitySupportChecker = highAvailabilitySupportChecker;
    }

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String format = context.getRepository().getFormat().getValue();
        if (!this.highAvailabilitySupportChecker.isSupported(format)) {
            return HttpResponses.badRequest(String.format("%s is not supported in clustered mode.", format));
        }
        return context.proceed();
    }
}

