/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpConditions;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;

public class ConditionalRequestHandler
extends ComponentSupport
implements Handler {
    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        if (HttpConditions.isConditional(context.getRequest())) {
            HttpConditions.makeUnconditional(context.getRequest());
            try {
                Response response = this.handleConditional(context);
                return response;
            }
            finally {
                HttpConditions.makeConditional(context.getRequest());
            }
        }
        return context.proceed();
    }

    @Nonnull
    private Response handleConditional(@Nonnull Context context) throws Exception {
        String action = context.getRequest().getAction();
        this.log.debug("Conditional request: {} {}", (Object)action, (Object)context.getRequest().getPath());
        switch (action) {
            case "GET": 
            case "HEAD": {
                Response response = context.proceed();
                if (response.getStatus().isSuccessful()) {
                    Optional<Response> conditionalResponse = HttpConditions.maybeCreateConditionalResponse(context, response);
                    return conditionalResponse.orElse(response);
                }
                return response;
            }
            case "PUT": 
            case "POST": 
            case "DELETE": {
                Optional<Response> conditionalResponse;
                Request getRequest = new Request.Builder().copy(context.getRequest()).action("GET").build();
                Response response = ((ViewFacet)context.getRepository().facet(ViewFacet.class)).dispatch(getRequest);
                if (response.getStatus().isSuccessful() && (conditionalResponse = HttpConditions.maybeCreateConditionalResponse(context, response)).isPresent()) {
                    return conditionalResponse.get();
                }
                return context.proceed();
            }
        }
        return context.proceed();
    }
}

