/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.handlers.SecurityHandler;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class BrowseUnsupportedHandler
extends ComponentSupport
implements Handler,
org.sonatype.nexus.repository.BrowseUnsupportedHandler {
    private static final String TEMPLATE_RESOURCE = "browseUnsupportedHtml.vm";
    private final TemplateHelper templateHelper;
    private final URL template;
    private final Route route;
    private static final Matcher MATCHER = new MatcherImpl();

    @Inject
    public BrowseUnsupportedHandler(TemplateHelper templateHelper, SecurityHandler securityHandler) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
        Preconditions.checkNotNull((Object)securityHandler);
        this.template = this.getClass().getResource(TEMPLATE_RESOURCE);
        Preconditions.checkNotNull((Object)this.template);
        this.route = new Route(MATCHER, (List<Handler>)ImmutableList.of((Object)securityHandler, (Object)this));
    }

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        TemplateParameters params = this.templateHelper.parameters();
        params.set("repository", (Object)context.getRepository());
        String html = this.templateHelper.render(this.template, params);
        return HttpResponses.ok(new StringPayload(html, "text/html"));
    }

    @Nonnull
    public Route getRoute() {
        return this.route;
    }

    private static class MatcherImpl
    extends ComponentSupport
    implements Matcher {
        private MatcherImpl() {
        }

        @Override
        public boolean matches(Context context) {
            Preconditions.checkNotNull((Object)context);
            String action = context.getRequest().getAction();
            String path = context.getRequest().getPath();
            this.log.debug("Matching: {} {}", (Object)action, (Object)path);
            if ("GET".equals(action)) {
                return (path = Strings2.lower((String)path)).endsWith("/") || path.endsWith("/index.html") || path.endsWith("/index.htm");
            }
            return false;
        }
    }
}

