/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import java.io.Serializable;
import javax.annotation.Nullable;

public class Status
implements Serializable {
    private final boolean successful;
    private final int code;
    private final String message;

    public Status(boolean successful, int code, @Nullable String message) {
        this.successful = successful;
        this.code = code;
        this.message = message;
    }

    public Status(boolean successful, int code) {
        this(successful, code, null);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "successful=" + this.successful + ", code=" + this.code + ", message='" + this.message + '\'' + '}';
    }

    public static Status success(int code, String message) {
        return new Status(true, code, message);
    }

    public static Status success(int code) {
        return new Status(true, code);
    }

    public static Status failure(int code, String message) {
        return new Status(false, code, message);
    }

    public static Status failure(int code) {
        return new Status(false, code);
    }
}

