/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Status;

public class Response {
    private final AttributesMap attributes;
    private final Headers headers;
    private final Status status;
    private final Payload payload;

    private Response(AttributesMap attributes, Headers headers, Status status, @Nullable Payload payload) {
        this.attributes = attributes;
        this.headers = headers;
        this.status = status;
        this.payload = payload;
    }

    public AttributesMap getAttributes() {
        return this.attributes;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public Payload getPayload() {
        return this.payload;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "status=" + this.status + ", payload=" + this.payload + '}';
    }

    /* synthetic */ Response(AttributesMap attributesMap, Headers headers, Status status, Payload payload, Response response) {
        this(attributesMap, headers, status, payload);
    }

    public static class Builder {
        private AttributesMap attributes;
        private Headers headers;
        private Status status;
        private Payload payload;

        public Builder attributes(AttributesMap attributes) {
            this.attributes = attributes;
            return this;
        }

        @Nonnull
        public AttributesMap attributes() {
            if (this.attributes == null) {
                this.attributes = new AttributesMap();
            }
            return this.attributes;
        }

        public Builder attribute(String name, Object value) {
            this.attributes().set(name, value);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        @Nonnull
        public Headers headers() {
            if (this.headers == null) {
                this.headers = new Headers();
            }
            return this.headers;
        }

        public Builder header(String name, String ... values) {
            this.headers().set(name, values);
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public Builder copy(Response response) {
            Preconditions.checkNotNull((Object)response);
            this.attributes = response.getAttributes();
            this.headers = response.getHeaders();
            this.status = response.getStatus();
            this.payload = response.getPayload();
            return this;
        }

        public Response build() {
            Preconditions.checkState((this.status != null ? 1 : 0) != 0, (Object)"Missing: status");
            return new Response(this.attributes(), this.headers(), this.status, this.payload, null);
        }
    }
}

