/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DockerRepoPathUtil {
    private static final Map<String, String> subdomainMapping = new ConcurrentHashMap<String, String>();

    private DockerRepoPathUtil() {
    }

    public static void setSubdomainMapping(String subdomain, String repoName) {
        subdomainMapping.put(subdomain, repoName);
    }

    public static String getPath(String requestURI, String hostHeader) {
        String subdomain;
        String repoName;
        int subdomainLength = hostHeader.indexOf(".");
        if (subdomainLength != -1 && (repoName = subdomainMapping.get(subdomain = hostHeader.substring(0, subdomainLength))) != null) {
            return "/" + repoName + requestURI;
        }
        return null;
    }

    public static void removeSubdomainMapping(String subdomain) {
        subdomainMapping.remove(subdomain);
    }
}

