/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.view.Payload;

public class Content
implements Payload {
    @VisibleForTesting
    public static final String CONTENT = "content";
    public static final String CONTENT_LAST_MODIFIED = "last_modified";
    public static final String CONTENT_ETAG = "etag";
    private final Payload payload;
    private final AttributesMap attributes;

    public Content(Payload payload) {
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload);
        this.attributes = new AttributesMap();
    }

    public Content(Content originalContent, Payload payload) {
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload);
        this.attributes = originalContent.getAttributes();
    }

    protected Content(Payload payload, AttributesMap attributes) {
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload);
        this.attributes = (AttributesMap)Preconditions.checkNotNull((Object)attributes);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.payload.openInputStream();
    }

    @Override
    public long getSize() {
        return this.payload.getSize();
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.payload.getContentType();
    }

    @Override
    public void close() throws IOException {
        this.payload.close();
    }

    @Override
    public void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.payload.copy(inputStream, outputStream);
    }

    public Payload getPayload() {
        return this.payload;
    }

    @Nonnull
    public AttributesMap getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "payload=" + this.payload + ", attributes='" + this.attributes + '\'' + '}';
    }
}

