/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpclient.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.Valid;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.message.BasicHeader;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.distributed.event.service.api.DistributedEvent;
import org.sonatype.nexus.distributed.event.service.api.common.PublisherEvent;
import org.sonatype.nexus.distributed.event.service.api.common.RepositoryRemoteConnectionStatusEvent;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.BearerTokenAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConfigurationCustomizer;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfigurationChangedEvent;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.httpclient.AutoBlockConfiguration;
import org.sonatype.nexus.repository.httpclient.ContentCompressionStrategy;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.httpclient.NormalizationStrategy;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatus;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusEvent;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusObserver;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusType;
import org.sonatype.nexus.repository.httpclient.internal.BlockingHttpClient;

@Named
public class HttpClientFacetImpl
extends FacetSupport
implements HttpClientFacet,
RemoteConnectionStatusObserver {
    private static final String DEFAULT = "default";
    private final HttpClientManager httpClientManager;
    @VisibleForTesting
    static final String CONFIG_KEY = "httpclient";
    private final Map<String, AutoBlockConfiguration> autoBlockConfiguration;
    private final Map<String, RedirectStrategy> redirectStrategy;
    private final Map<String, NormalizationStrategy> normalizationStrategies;
    private final Map<String, ContentCompressionStrategy> contentCompressionStrategies;
    private final Map<String, TargetAuthenticationStrategy> authenticationStrategies;
    private Config config;
    @VisibleForTesting
    BlockingHttpClient httpClient;

    @Inject
    public HttpClientFacetImpl(HttpClientManager httpClientManager, Map<String, AutoBlockConfiguration> autoBlockConfiguration, Map<String, RedirectStrategy> redirectStrategy, Map<String, NormalizationStrategy> normalizationStrategies, Map<String, ContentCompressionStrategy> contentCompressionStrategies, Map<String, TargetAuthenticationStrategy> authenticationStrategies) {
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
        this.autoBlockConfiguration = (Map)Preconditions.checkNotNull(autoBlockConfiguration);
        this.redirectStrategy = (Map)Preconditions.checkNotNull(redirectStrategy);
        this.normalizationStrategies = (Map)Preconditions.checkNotNull(normalizationStrategies);
        this.contentCompressionStrategies = (Map)Preconditions.checkNotNull(contentCompressionStrategies);
        this.authenticationStrategies = (Map)Preconditions.checkNotNull(authenticationStrategies);
    }

    @VisibleForTesting
    HttpClientFacetImpl(HttpClientManager httpClientManager, Map<String, AutoBlockConfiguration> autoBlockConfiguration, Map<String, RedirectStrategy> redirectStrategy, Map<String, NormalizationStrategy> normalizationStrategy, Map<String, ContentCompressionStrategy> contentCompressionStrategies, Map<String, TargetAuthenticationStrategy> authenticationStrategies, Config config) {
        this(httpClientManager, autoBlockConfiguration, redirectStrategy, normalizationStrategy, contentCompressionStrategies, authenticationStrategies);
        this.config = (Config)Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)autoBlockConfiguration.get(DEFAULT));
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
        this.createHttpClient();
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    protected void doStop() throws Exception {
        this.closeHttpClient();
    }

    @Override
    @Guarded(by={"STARTED"})
    public HttpClient getHttpClient() {
        return (HttpClient)Preconditions.checkNotNull((Object)((Object)this.httpClient));
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public Header createBasicAuthHeader() {
        if (this.config.authentication instanceof UsernameAuthenticationConfiguration) {
            UsernameAuthenticationConfiguration userAuth = (UsernameAuthenticationConfiguration)this.config.authentication;
            String auth = String.format("%1$s:%2$s", userAuth.getUsername(), userAuth.getPassword());
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.ISO_8859_1));
            String authHeader = "Basic " + new String(encodedAuth, StandardCharsets.ISO_8859_1);
            return new BasicHeader("Authorization", authHeader);
        }
        this.log.debug("Basic auth header cannot be created for auth config of {}", (Object)this.config.authentication);
        return null;
    }

    @Override
    public String getBearerToken() {
        if (this.config.authentication != null && "bearerToken".equals(this.config.authentication.getType())) {
            return ((BearerTokenAuthenticationConfiguration)this.config.authentication).getBearerToken();
        }
        return null;
    }

    @Override
    @Guarded(by={"STARTED"})
    public RemoteConnectionStatus getStatus() {
        return this.httpClient.getStatus();
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setStatus(RemoteConnectionStatus status) {
        this.httpClient.setRemoteConnectionStatus(status);
    }

    @Subscribe
    public void on(HttpClientConfigurationChangedEvent event) throws IOException {
        this.closeHttpClient();
        this.createHttpClient();
    }

    @Override
    public void onStatusChanged(RemoteConnectionStatus oldStatus, RemoteConnectionStatus newStatus) {
        this.logStatusChange(oldStatus, newStatus);
        this.getEventManager().post((Object)new RemoteConnectionStatusEvent(newStatus, this.getRepository()));
        this.distributeRepositoryConnectionStatusChangedEvent(this.getRepository().getName(), newStatus);
    }

    private void logStatusChange(RemoteConnectionStatus oldStatus, RemoteConnectionStatus newStatus) {
        if (this.log.isInfoEnabled()) {
            if (oldStatus.getType() == RemoteConnectionStatusType.AUTO_BLOCKED_UNAVAILABLE && newStatus.getType() == RemoteConnectionStatusType.AUTO_BLOCKED_UNAVAILABLE) {
                this.logAutoBlockTimeIncreased(oldStatus, newStatus);
            } else if (oldStatus.getType() == RemoteConnectionStatusType.UNINITIALISED) {
                this.log.info("Remote connection status of repository {} set to {}.", (Object)this.getRepository().getName(), (Object)newStatus.getDescription());
            } else {
                this.logStatusUpdated(oldStatus, newStatus);
            }
        }
    }

    private void logAutoBlockTimeIncreased(RemoteConnectionStatus oldStatus, RemoteConnectionStatus newStatus) {
        String message = "Repository status for {} continued as {} until {} - reason {} (previous reason was {})";
        this.log.info(message, new Object[]{this.getRepository().getName(), newStatus.getType(), newStatus.getBlockedUntil(), HttpClientFacetImpl.statusReason(newStatus), HttpClientFacetImpl.statusReason(oldStatus)});
    }

    private void logStatusUpdated(RemoteConnectionStatus oldStatus, RemoteConnectionStatus newStatus) {
        String message = "Repository status for {} changed from {} to {}{} - reason {}";
        this.log.info(message, new Object[]{this.getRepository().getName(), oldStatus.getType(), newStatus.getType(), HttpClientFacetImpl.statusBlockedUntil(newStatus), HttpClientFacetImpl.statusReason(newStatus)});
    }

    private static String statusBlockedUntil(RemoteConnectionStatus status) {
        if (status.getBlockedUntil() != null) {
            return String.format(" until %s", status.getBlockedUntil());
        }
        return "";
    }

    private static String statusReason(RemoteConnectionStatus status) {
        return String.format("%s for %s", status.getReason() != null ? status.getReason() : "n/a", status.getRequestUrl() != null ? status.getRequestUrl() : "n/a");
    }

    private void createHttpClient() {
        HttpClientConfiguration delegateConfig = this.getHttpClientConfiguration(this.httpClientManager, this.config);
        CloseableHttpClient delegate = this.httpClientManager.create((HttpClientPlan.Customizer)new ConfigurationCustomizer(delegateConfig));
        boolean online = this.getRepository().getConfiguration().isOnline();
        this.httpClient = new BlockingHttpClient(delegate, this.config, this, online, this.getAutoBlockConfiguration());
        this.log.debug("Created HTTP client: {}", (Object)this.httpClient);
    }

    protected HttpClientConfiguration getHttpClientConfiguration(HttpClientManager httpClientManager, Config config) {
        HttpClientConfiguration delegateConfig = httpClientManager.newConfiguration();
        delegateConfig.setConnection(config.connection);
        delegateConfig.setAuthentication(config.authentication);
        delegateConfig.setRedirectStrategy(this.getRedirectStrategy());
        this.setNormalizationStrategy(delegateConfig);
        this.setContentCompressionStrategy(delegateConfig);
        this.setAuthenticationStrategy(delegateConfig);
        return delegateConfig;
    }

    private AutoBlockConfiguration getAutoBlockConfiguration() {
        AutoBlockConfiguration config = this.autoBlockConfiguration.get(this.getRepository().getFormat().getValue());
        if (config == null) {
            config = this.autoBlockConfiguration.get(DEFAULT);
        }
        return config;
    }

    protected RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy.get(this.getRepository().getFormat().getValue());
    }

    protected void setNormalizationStrategy(HttpClientConfiguration delegateConfig) {
        Optional.ofNullable(this.normalizationStrategies.get(this.getRepository().getFormat().getValue())).ifPresent(strategy -> delegateConfig.setNormalizeUri(Boolean.valueOf(strategy.shouldNormalizeUri())));
    }

    protected void setContentCompressionStrategy(HttpClientConfiguration delegateConfig) {
        Optional.ofNullable(this.contentCompressionStrategies.get(this.getRepository().getFormat().getValue())).ifPresent(strategy -> delegateConfig.setDisableContentCompression(Boolean.valueOf(strategy.shouldDisableContentCompression(this.getRepository().getName()))));
    }

    private void setAuthenticationStrategy(HttpClientConfiguration delegateConfig) {
        Optional.ofNullable(this.authenticationStrategies.get(this.getRepository().getFormat().getValue())).ifPresent(arg_0 -> ((HttpClientConfiguration)delegateConfig).setAuthenticationStrategy(arg_0));
    }

    private void closeHttpClient() throws IOException {
        this.log.debug("Closing HTTP client: {}", (Object)this.httpClient);
        this.httpClient.close();
        this.httpClient = null;
    }

    private void distributeRepositoryConnectionStatusChangedEvent(String repositoryName, RemoteConnectionStatus status) {
        this.log.debug("Distribute repository block changed event: repository={}:{}", (Object)repositoryName, (Object)status.getType());
        long blockUntilMillis = status.getBlockedUntil() == null ? DateTime.now().getMillis() : status.getBlockedUntil().getMillis();
        RepositoryRemoteConnectionStatusEvent event = new RepositoryRemoteConnectionStatusEvent(repositoryName, status.getType().ordinal(), status.getReason(), blockUntilMillis, status.getRequestUrl());
        this.getEventManager().post((Object)new PublisherEvent((DistributedEvent)event));
    }

    @VisibleForTesting
    static class Config {
        @Valid
        @Nullable
        public ConnectionConfiguration connection;
        @Valid
        @Nullable
        public AuthenticationConfiguration authentication;
        @Nullable
        public Boolean blocked;
        @Nullable
        public Boolean autoBlock;

        Config() {
        }
    }
}

