/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpclient.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.impl.client.CloseableHttpClient;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.sequence.FibonacciNumberSequence;
import org.sonatype.nexus.common.sequence.NumberSequence;
import org.sonatype.nexus.repository.httpclient.AutoBlockConfiguration;
import org.sonatype.nexus.repository.httpclient.FilteredHttpClientSupport;
import org.sonatype.nexus.repository.httpclient.RemoteBlockedIOException;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatus;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusObserver;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusType;
import org.sonatype.nexus.repository.httpclient.internal.HttpClientFacetImpl;

public class BlockingHttpClient
extends FilteredHttpClientSupport {
    private static final Logger log = LoggerFactory.getLogger(BlockingHttpClient.class);
    private final boolean blocked;
    @VisibleForTesting
    final AutoBlockConfiguration autoBlockConfiguration;
    private HttpHost mainTarget;
    private DateTime blockedUntil;
    private Thread checkStatusThread;
    private final boolean autoBlock;
    private final NumberSequence autoBlockSequence;
    private final RemoteConnectionStatusObserver statusObserver;
    private RemoteConnectionStatus status = new RemoteConnectionStatus(RemoteConnectionStatusType.UNINITIALISED);

    public BlockingHttpClient(CloseableHttpClient delegate, HttpClientFacetImpl.Config config, RemoteConnectionStatusObserver statusObserver, boolean repositoryOnline, AutoBlockConfiguration autoBlockConfiguration) {
        super(delegate);
        Preconditions.checkNotNull((Object)config);
        this.statusObserver = (RemoteConnectionStatusObserver)Preconditions.checkNotNull((Object)statusObserver);
        this.autoBlockConfiguration = (AutoBlockConfiguration)Preconditions.checkNotNull((Object)autoBlockConfiguration);
        this.blocked = config.blocked != null ? config.blocked : false;
        boolean bl = this.autoBlock = config.autoBlock != null ? config.autoBlock : false;
        if (repositoryOnline) {
            this.updateStatus(this.blocked ? RemoteConnectionStatusType.BLOCKED : RemoteConnectionStatusType.READY);
        } else {
            this.updateStatus(RemoteConnectionStatusType.OFFLINE);
        }
        this.autoBlockSequence = new FibonacciNumberSequence(Time.seconds((long)40L).toMillis());
    }

    @Override
    protected CloseableHttpResponse filter(HttpHost target, FilteredHttpClientSupport.Filterable filterable) throws IOException {
        if (this.mainTarget == null) {
            this.mainTarget = target;
        }
        if (!target.equals((Object)this.mainTarget)) {
            return filterable.call();
        }
        if (this.blocked) {
            throw new RemoteBlockedIOException("Remote Manually Blocked");
        }
        DateTime blockedUntilCopy = this.blockedUntil;
        if (this.autoBlock && blockedUntilCopy != null && blockedUntilCopy.isAfterNow()) {
            throw new RemoteBlockedIOException("Remote Auto Blocked until " + blockedUntilCopy);
        }
        try {
            CloseableHttpResponse response = filterable.call();
            int statusCode = response.getStatusLine().getStatusCode();
            if (this.autoBlockConfiguration.shouldBlock(statusCode)) {
                this.updateStatusToUnavailable(this.getReason(statusCode), target);
            } else {
                this.updateStatusToAvailable();
            }
            return response;
        }
        catch (IOException e) {
            if (this.isRemoteUnavailable(e)) {
                this.updateStatusToUnavailable(this.getReason(e), target);
            }
            throw e;
        }
    }

    private synchronized void updateStatusToAvailable() {
        if (this.autoBlock && this.blockedUntil != null) {
            this.blockedUntil = null;
            this.interruptCheckStatusThread();
            this.autoBlockSequence.reset();
        }
        this.updateStatus(RemoteConnectionStatusType.AVAILABLE);
    }

    private synchronized void updateStatusToUnavailable(String reason, HttpHost target) {
        if (this.autoBlock) {
            if (this.blockedUntil == null || this.blockedUntil.isBeforeNow()) {
                this.blockedUntil = DateTime.now().plus(this.autoBlockSequence.next());
                this.interruptCheckStatusThread();
                String uri = target.toURI();
                this.scheduleCheckStatus(uri, this.blockedUntil);
            }
            this.updateStatus(RemoteConnectionStatusType.AUTO_BLOCKED_UNAVAILABLE, reason, target.toURI(), this.blockedUntil.isAfter((ReadableInstant)this.status.getBlockedUntil()));
        } else {
            this.updateStatus(RemoteConnectionStatusType.UNAVAILABLE, reason, target.toURI(), false);
        }
    }

    @VisibleForTesting
    void scheduleCheckStatus(String uri, DateTime until) {
        this.checkStatusThread = new Thread((Runnable)new CheckStatus(uri, until), "Check Status " + uri);
        this.checkStatusThread.setDaemon(true);
        this.checkStatusThread.start();
    }

    private void updateStatus(RemoteConnectionStatusType type, String reason, @Nullable String url, boolean autoBlockTimeIncrease) {
        if (type != this.status.getType() || autoBlockTimeIncrease) {
            RemoteConnectionStatus oldStatus = this.status;
            this.status = new RemoteConnectionStatus(type, reason).setBlockedUntil(this.blockedUntil).setRequestUrl(url);
            this.statusObserver.onStatusChanged(oldStatus, this.status);
        }
    }

    private void updateStatus(RemoteConnectionStatusType type) {
        this.updateStatus(type, null, null, false);
    }

    public RemoteConnectionStatus getStatus() {
        return this.status;
    }

    public void setRemoteConnectionStatus(RemoteConnectionStatus status) {
        this.status = status;
    }

    private boolean isRemoteUnavailable(Exception e) {
        return !(e instanceof ConnectionPoolTimeoutException);
    }

    private String getReason(Exception e) {
        if (e instanceof SSLPeerUnverifiedException) {
            return "Untrusted Remote";
        }
        return String.valueOf(e.getClass().getName()) + ": " + e.getMessage();
    }

    private String getReason(int statusCode) {
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, Locale.ENGLISH);
        return reason == null ? "Unrecognized HTTP error, code " + statusCode : reason;
    }

    @Override
    public void close() throws IOException {
        this.interruptCheckStatusThread();
        super.close();
    }

    private void interruptCheckStatusThread() {
        if (this.checkStatusThread != null) {
            if (this.checkStatusThread != Thread.currentThread()) {
                this.checkStatusThread.interrupt();
            }
            this.checkStatusThread = null;
        }
    }

    private class CheckStatus
    implements Runnable {
        private final String uri;
        private final DateTime fireAt;

        private CheckStatus(String uri, DateTime fireAt) {
            this.uri = uri;
            this.fireAt = fireAt;
        }

        @Override
        public void run() {
            if (this.fireAt.isAfterNow()) {
                try {
                    long durationTillFire = new Duration((ReadableInstant)DateTime.now(), (ReadableInstant)this.fireAt).getMillis();
                    if (durationTillFire > 0L) {
                        log.debug("Wait until {} to check status of {}", (Object)this.fireAt, (Object)this.uri);
                        Thread.sleep(durationTillFire);
                        log.debug("Time is up. Checking status of {}", (Object)this.uri);
                        BlockingHttpClient.this.execute((HttpUriRequest)new HttpHead(this.uri));
                    }
                }
                catch (InterruptedException interruptedException) {
                    log.debug("Stopped checking status of {}", (Object)this.uri);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

