/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpclient;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusType;

public class RemoteConnectionStatus {
    private final RemoteConnectionStatusType type;
    private final String reason;
    private DateTime blockedUntil;
    private String requestUrl;

    public RemoteConnectionStatus(RemoteConnectionStatusType type) {
        this(type, null);
    }

    public RemoteConnectionStatus(RemoteConnectionStatusType type, @Nullable String reason) {
        this.type = (RemoteConnectionStatusType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.reason = reason;
    }

    public String getDescription() {
        return this.type.getDescription();
    }

    public RemoteConnectionStatusType getType() {
        return this.type;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.getDescription());
        if (this.reason != null) {
            sb.append(" - ").append(this.reason);
        }
        return sb.toString();
    }

    @Nullable
    public DateTime getBlockedUntil() {
        return this.blockedUntil;
    }

    public RemoteConnectionStatus setBlockedUntil(@Nullable DateTime blockedUntil) {
        this.blockedUntil = blockedUntil;
        return this;
    }

    @Nullable
    public String getRequestUrl() {
        return this.requestUrl;
    }

    public RemoteConnectionStatus setRequestUrl(@Nullable String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }
}

