/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.http;

import com.google.common.base.Strings;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.List;
import org.sonatype.goodies.common.ComponentSupport;

class RangeParser
extends ComponentSupport {
    public static final List<Range<Long>> UNSATISFIABLE = null;
    public static final List<Range<Long>> WHOLE_RANGE = Collections.emptyList();

    RangeParser() {
    }

    public List<Range<Long>> parseRangeSpec(String rangeHeader, long size) {
        Range content = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(size - 1L));
        if (!Strings.isNullOrEmpty((String)rangeHeader)) {
            try {
                if (rangeHeader.startsWith("bytes=") && rangeHeader.length() > 6 && !rangeHeader.contains(",")) {
                    String rangeSpec = rangeHeader.substring(6, rangeHeader.length());
                    if (rangeSpec.startsWith("-")) {
                        long byteCount = Long.parseLong(rangeSpec.substring(1));
                        if (byteCount > size) {
                            return UNSATISFIABLE;
                        }
                        Range suffix = Range.atLeast((Comparable)Long.valueOf(size - byteCount));
                        return this.ensureSatisfiable((Range<Long>)suffix, (Range<Long>)content);
                    }
                    if (rangeSpec.endsWith("-")) {
                        Range requested = Range.atLeast((Comparable)Long.valueOf(Long.parseLong(rangeSpec.substring(0, rangeSpec.length() - 1))));
                        return this.ensureSatisfiable((Range<Long>)requested, (Range<Long>)content);
                    }
                    if (rangeSpec.contains("-")) {
                        String[] parts = rangeSpec.split("-");
                        return this.ensureSatisfiable((Range<Long>)Range.closed((Comparable)Long.valueOf(Long.parseLong(parts[0])), (Comparable)Long.valueOf(Long.parseLong(parts[1]))), (Range<Long>)content);
                    }
                    this.log.warn("Malformed HTTP Range value: {}, ignoring it", (Object)rangeHeader);
                } else {
                    this.log.warn("Unsupported non-byte or multiple HTTP Ranges: {}; sending complete content", (Object)rangeHeader);
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Problem parsing Range value: {}, ignoring", (Object)rangeHeader, (Object)e);
                }
                this.log.warn("Problem parsing Range value: {}, ignoring: {}", (Object)rangeHeader, (Object)e.toString());
            }
        }
        return WHOLE_RANGE;
    }

    private List<Range<Long>> ensureSatisfiable(Range<Long> requested, Range<Long> content) {
        if (requested.isConnected(content)) {
            return Collections.singletonList(requested.intersection(content));
        }
        return UNSATISFIABLE;
    }

    private boolean isSatisfiable(Range<Long> range, long contentSize) {
        if (!range.hasLowerBound()) {
            return true;
        }
        return (Long)range.lowerEndpoint() < contentSize - 1L;
    }
}

