/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.http;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

public class HttpResponses {
    private HttpResponses() {
    }

    public static Response ok(@Nullable String message) {
        return new Response.Builder().status(Status.success(200, message)).build();
    }

    public static Response ok() {
        return HttpResponses.ok(null);
    }

    public static Response ok(Payload payload) {
        return new Response.Builder().status(Status.success(200)).payload(payload).build();
    }

    public static Response created(@Nullable String message) {
        return new Response.Builder().status(Status.success(201, message)).build();
    }

    public static Response created() {
        return HttpResponses.created(null);
    }

    public static Response created(Payload payload) {
        return new Response.Builder().status(Status.success(201)).payload(payload).build();
    }

    public static Response accepted() {
        return new Response.Builder().status(Status.success(202)).build();
    }

    public static Response noContent(@Nullable String message) {
        return new Response.Builder().status(Status.success(204, message)).build();
    }

    public static Response noContent() {
        return HttpResponses.noContent(null);
    }

    public static Response notFound(@Nullable String message) {
        return new Response.Builder().status(Status.failure(404, message)).build();
    }

    public static Response notFound() {
        return HttpResponses.notFound(null);
    }

    public static Response badRequest(@Nullable String message) {
        return new Response.Builder().status(Status.failure(400, message)).build();
    }

    public static Response badRequest() {
        return HttpResponses.badRequest(null);
    }

    public static Response unauthorized(@Nullable String message) {
        return new Response.Builder().status(Status.failure(401, message)).build();
    }

    public static Response unauthorized() {
        return HttpResponses.unauthorized(null);
    }

    public static Response unauthorized(String message, String authenticationScheme, String realmName) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)authenticationScheme);
        Preconditions.checkNotNull((Object)realmName);
        return new Response.Builder().status(Status.failure(401, message)).header("WWW-Authenticate", String.format("%s realm=\"%s\"", authenticationScheme, realmName)).build();
    }

    public static Response forbidden(@Nullable String message) {
        return new Response.Builder().status(Status.failure(403, message)).build();
    }

    public static Response forbidden() {
        return HttpResponses.forbidden(null);
    }

    public static Response methodNotAllowed(String methodName, String ... allowedMethods) {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)allowedMethods);
        Preconditions.checkArgument((allowedMethods.length != 0 ? 1 : 0) != 0);
        return new Response.Builder().status(Status.failure(405, methodName)).header("Allow", Joiner.on((char)',').join((Object[])allowedMethods)).build();
    }

    public static Response serviceUnavailable(@Nullable String message) {
        return new Response.Builder().status(Status.failure(503, message)).build();
    }

    public static Response serviceUnavailable() {
        return HttpResponses.serviceUnavailable(null);
    }

    public static Response badGateway(@Nullable String message) {
        return new Response.Builder().status(Status.failure(502, message)).build();
    }

    public static Response badGateway() {
        return HttpResponses.badGateway(null);
    }

    public static Response notImplemented(@Nullable String message) {
        return new Response.Builder().status(Status.failure(501, message)).build();
    }

    public static Response rangeNotSatisfiable(long contentSize) {
        return new Response.Builder().status(Status.failure(416)).header("Content-Length", "0").header("Content-Range", "bytes */" + contentSize).build();
    }
}

