/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.date;

import java.time.LocalDateTime;
import org.sonatype.nexus.scheduling.schedule.Weekly;

public class TimeZoneUtils {
    private TimeZoneUtils() {
    }

    public static int shiftWeekDay(int weekDayNumber, LocalDateTime clientDate, LocalDateTime serverDate) {
        int compare = clientDate.toLocalDate().compareTo(serverDate.toLocalDate());
        if (compare > 0) {
            return weekDayNumber - 1 < Weekly.Weekday.SUN.ordinal() ? Weekly.Weekday.SAT.ordinal() : weekDayNumber - 1;
        }
        if (compare < 0) {
            return weekDayNumber + 1 > Weekly.Weekday.SAT.ordinal() ? Weekly.Weekday.SUN.ordinal() : weekDayNumber + 1;
        }
        return weekDayNumber;
    }

    public static int shiftMonthDay(int monthDay, LocalDateTime clientDate, LocalDateTime serverDate) {
        int lengthOfMonth = serverDate.toLocalDate().lengthOfMonth();
        int compare = clientDate.toLocalDate().compareTo(serverDate.toLocalDate());
        if (compare > 0) {
            return monthDay - 1 < 1 ? lengthOfMonth : monthDay - 1;
        }
        if (compare < 0) {
            return monthDay + 1 > lengthOfMonth ? 1 : monthDay + 1;
        }
        return monthDay;
    }
}

