/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="tags", from="1.0", to="1.1")
@DependsOn(model="component", version="1.11", checkpoint=true)
public class TagsUpgrade_1_1
extends DatabaseUpgradeSupport {
    static final String P_TAG_NAME = "name";
    static final String P_ATTRIBUTES = "attributes";
    static final String TAGS_DB_CLASS = new OClassNameBuilder().type("tag").build();
    static final String I_TAG_NAME = new OIndexNameBuilder().type(TAGS_DB_CLASS).property("name").build();
    static final String P_TAGS = "tags";
    static final String COMPONENTS_DB_CLASS = new OClassNameBuilder().type("component").build();
    static final String I_COMPONENT_TAGS = new OIndexNameBuilder().type(COMPONENTS_DB_CLASS).property("tags").build();
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public TagsUpgrade_1_1(@Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() {
        this.updateTagsSchema();
        this.updateComponentsSchema();
    }

    private void updateTagsSchema() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
            OIndexManagerProxy indexManager;
            OProperty property;
            OSchemaProxy schema = db.getMetadata().getSchema();
            OClass type = schema.getClass(TAGS_DB_CLASS);
            if (type == null) {
                type = schema.createClass(TAGS_DB_CLASS);
                this.log.debug("Created type {}", (Object)type);
            }
            if (type.getProperty(P_TAG_NAME) == null) {
                property = type.createProperty(P_TAG_NAME, OType.STRING).setMandatory(true).setNotNull(true);
                this.log.debug("Created property {}", (Object)property);
            }
            if (type.getProperty(P_ATTRIBUTES) == null) {
                property = type.createProperty(P_ATTRIBUTES, OType.EMBEDDEDMAP).setNotNull(true);
                this.log.debug("Created property {}", (Object)property);
            }
            if ((indexManager = db.getMetadata().getIndexManager()).getIndex(I_TAG_NAME) == null) {
                OIndex index = type.createIndex(I_TAG_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_TAG_NAME});
                this.log.debug("Created index {}", (Object)index);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateComponentsSchema() {
        TagsUpgrade_1_1.withDatabaseAndClass(this.componentDatabaseInstance, (String)COMPONENTS_DB_CLASS, (db, table) -> {
            OIndexManagerProxy indexManager;
            if (table.getProperty(P_TAGS) == null) {
                OSchemaProxy schema = db.getMetadata().getSchema();
                OProperty property = table.createProperty(P_TAGS, OType.LINKLIST, schema.getClass(TAGS_DB_CLASS), true).setDefaultValue("[]");
                this.log.debug("Created property {}", (Object)property);
            }
            if ((indexManager = db.getMetadata().getIndexManager()).getIndex(I_COMPONENT_TAGS) == null) {
                OIndex index = new OIndexBuilder(table, I_COMPONENT_TAGS, OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX).property(P_TAGS, OType.LINKLIST).ignoreNullValues().build(db);
                this.log.debug("Created index {}", (Object)index);
            }
        });
    }
}

