/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class TagNotFoundException
extends RuntimeException {
    private final Collection<String> tags;

    public TagNotFoundException(String tag) {
        this((Collection<String>)ImmutableSet.of((Object)tag));
    }

    public TagNotFoundException(Collection<String> tags) {
        this.tags = (Collection)Preconditions.checkNotNull(tags);
    }

    @Override
    public String getMessage() {
        if (this.tags.size() == 1) {
            return String.format("Tag '%s' not found", Iterables.getFirst(this.tags, null));
        }
        if (this.tags.size() > 1) {
            return String.format("Tags '%s' not found", String.join((CharSequence)",", this.tags));
        }
        return "Tag not found";
    }
}

