/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.ComponentTag;
import com.sonatype.nexus.tags.datastore.ComponentTagStoreManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.search.SearchDocumentExtension;

@Named
@Singleton
public class TagSearchDocumentExtension
extends ComponentSupport
implements SearchDocumentExtension {
    private final ComponentTagStoreManager componentTagStoreManager;
    private final TagStore tagStore;

    @Inject
    public TagSearchDocumentExtension(ComponentTagStoreManager componentTagStoreManager, TagStore tagStore) {
        this.componentTagStoreManager = (ComponentTagStoreManager)Preconditions.checkNotNull((Object)componentTagStoreManager);
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
    }

    public Map<String, Object> getFields(FluentComponent component) {
        return ImmutableMap.of((Object)"tags", this.getTags(component));
    }

    private List<String> getTags(FluentComponent component) {
        BiFunction<Integer, String, Continuation> browseFunction = (limit, token) -> this.componentTagStoreManager.getStoreForRepository(component.repository()).browseComponentTags((Component)component, (int)limit, (String)token);
        Set<Integer> tagIds = Continuations.streamOf(browseFunction).map(ComponentTag::getTagId).collect(Collectors.toSet());
        return this.tagStore.getByIds(tagIds).stream().map(Tag::name).collect(Collectors.toList());
    }
}

