/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.search;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Singleton;
import com.sonatype.nexus.tags.datastore.ComponentTagEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.content.search.SearchEventHandler;

@FeatureFlag(name="nexus.datastore.enabled")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
public class SearchTagEventHandler
extends LifecycleSupport
implements EventAware {
    private final SearchEventHandler searchEventHandler;

    @Inject
    public SearchTagEventHandler(SearchEventHandler searchEventHandler) {
        this.searchEventHandler = (SearchEventHandler)Preconditions.checkNotNull((Object)searchEventHandler);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentTagEvent event) {
        this.requestIndex(event);
    }

    private void requestIndex(ComponentTagEvent event) {
        event.getRepository().ifPresent(repository -> this.searchEventHandler.requestIndex(event.getFormat(), event.getComponentTag().getComponentId(), repository));
    }
}

