/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.orient.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.orient.OrientTag;
import com.sonatype.nexus.tags.orient.OrientTagCleanupQuery;
import com.sonatype.nexus.tags.orient.internal.BrowseTagsSqlBuilder;
import com.sonatype.nexus.tags.orient.internal.TagEntityAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.Valid;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.ContinuationTokenHelper;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.validation.Validate;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientTagStore
extends StateGuardLifecycleSupport
implements TagStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final TagEntityAdapter entityAdapter;
    private final BrowseTagsSqlBuilder browseTagsSqlBuilder;
    private final ContinuationTokenHelper continuationTokenHelper;

    @Inject
    public OrientTagStore(@Named(value="component") Provider<DatabaseInstance> databaseInstance, TagEntityAdapter entityAdapter, BrowseTagsSqlBuilder browseTagsSqlBuilder, @Named(value="tag") ContinuationTokenHelper continuationTokenHelper) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (TagEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.browseTagsSqlBuilder = (BrowseTagsSqlBuilder)((Object)Preconditions.checkNotNull((Object)((Object)browseTagsSqlBuilder)));
        this.continuationTokenHelper = (ContinuationTokenHelper)Preconditions.checkNotNull((Object)continuationTokenHelper);
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Tag> list() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    public List<Tag> browse(QueryOptions queryOptions) {
        return (List)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
            String query = this.browseTagsSqlBuilder.buildBrowseSql(queryOptions);
            Map<String, Object> parameters = this.browseTagsSqlBuilder.buildSqlParams(queryOptions);
            Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
            return this.getTags(docs);
        });
    }

    @Override
    public String getContinuationToken(List<Tag> page) {
        return this.continuationTokenHelper.getTokenFromId((Entity)((OrientTag)Iterables.getLast(page)));
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public Tag get(String name) {
        return (Tag)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.read(db, name));
    }

    @Override
    public List<Tag> get(Set<String> names) {
        return (List)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> ImmutableList.copyOf(this.entityAdapter.read(db, names)));
    }

    @Override
    public List<Tag> getByIds(Set<Integer> ids) {
        throw new UnsupportedOperationException("Getting tags by ID is not supported in the OrientTagStore");
    }

    @Override
    @Guarded(by={"STARTED"})
    @Validate
    public void create(@Valid Tag tag) {
        Preconditions.checkNotNull((Object)tag);
        this.checkEntityType(tag);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)((OrientTag)tag));
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(@Valid Tag tag) {
        Preconditions.checkNotNull((Object)tag);
        this.checkEntityType(tag);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.editEntity(db, (Entity)((OrientTag)tag));
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(Tag tag) {
        Preconditions.checkNotNull((Object)tag);
        this.checkEntityType(tag);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)((OrientTag)tag)));
    }

    @Override
    public Tag newTag() {
        return this.entityAdapter.newEntity();
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Tag> getTagsForCleanup(Integer firstCreatedDaysOld, Integer lastUpdatedDaysOld, Pattern nameRegex) {
        OrientTagCleanupQuery orientTagCleanupQuery = OrientTagCleanupQuery.builder().firstCreatedDaysOld(firstCreatedDaysOld).lastUpdatedDaysOld(lastUpdatedDaysOld).nameRegex(nameRegex).build();
        return this.query(orientTagCleanupQuery);
    }

    private List<Tag> getTags(Iterable<ODocument> results) {
        Preconditions.checkNotNull(results);
        return Lists.newArrayList((Iterable)StreamSupport.stream(results.spliterator(), false).map(arg_0 -> ((TagEntityAdapter)this.entityAdapter).readEntity(arg_0)).collect(Collectors.toList()));
    }

    private void checkEntityType(Tag tag) {
        Preconditions.checkArgument((boolean)(tag instanceof OrientTag), (Object)"Tag is not an OrientTag");
    }

    private List<Tag> query(OrientTagCleanupQuery tagCleanupQuery) {
        return (List)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
            String query = String.format("SELECT FROM %s WHERE %s", TagEntityAdapter.DB_CLASS, tagCleanupQuery.getWhere());
            Iterable docs = (Iterable)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[]{tagCleanupQuery.getParams()});
            return this.getTags(docs);
        });
    }
}

