/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.orient.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.service.TagCleanupService;
import com.sonatype.nexus.tags.service.TagService;
import com.sonatype.nexus.tags.tasks.TagCleanupTaskConfiguration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@Singleton
public class OrientTagCleanupServiceImpl
extends StateGuardLifecycleSupport
implements TagCleanupService {
    private final TagStore tagStore;
    private final RepositoryManager repositoryManager;
    private final SearchService searchService;
    private final TagService tagService;

    @Inject
    public OrientTagCleanupServiceImpl(TagStore tagStore, RepositoryManager repositoryManager, SearchService searchService, TagService tagService) {
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
    }

    @Override
    public void cleanup(TagCleanupTaskConfiguration configuration) {
        List<Tag> results = this.tagStore.getTagsForCleanup(configuration.getFirstCreatedDaysOld(), configuration.getLastUpdatedDaysOld(), configuration.getNameRegex());
        for (Tag tag : results) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Delete tag '{}' ", (Object)tag.name());
            this.cleanComponentsForTag(configuration, tag);
            CancelableHelper.checkCancellation();
            this.tagStore.delete(tag);
        }
    }

    private Repository getRepository(ComponentSearchResult hit) {
        return this.repositoryManager.get(hit.getRepositoryName());
    }

    private void cleanComponentsForTag(TagCleanupTaskConfiguration configuration, Tag tag) {
        SearchRequest request = SearchRequest.builder().searchFilter("tags", tag.name()).disableAuthorization().build();
        for (ComponentSearchResult hit : this.searchService.browse(request)) {
            this.cleanComponent(configuration, tag, hit);
        }
    }

    private void cleanComponent(TagCleanupTaskConfiguration configuration, Tag tag, ComponentSearchResult hit) {
        CancelableHelper.checkCancellation();
        Repository repository = this.getRepository(hit);
        if (this.shouldDeleteComponent(configuration, repository)) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Deleting component with id '{}'", (Object)hit.getId());
            if (((ComponentMaintenance)repository.facet(ComponentMaintenance.class)).deleteComponent((EntityId)new DetachedEntityId(hit.getId())).isEmpty()) {
                this.log.warn("Failed to find component '{}' during deletion of tag '{}'", (Object)hit.getId(), (Object)tag.name());
            }
        } else {
            this.tagService.disassociateById(tag, repository, (EntityId)new DetachedEntityId(hit.getId()));
        }
    }

    private boolean shouldDeleteComponent(TagCleanupTaskConfiguration configuration, Repository repository) {
        if (!configuration.getDeleteAssociatedComponents().booleanValue()) {
            return false;
        }
        String restrictByRepository = configuration.getRestrictComponentDelete();
        if (!Strings.isNullOrEmpty((String)restrictByRepository)) {
            boolean matchesRepositoryName;
            RepositorySelector repositorySelector = RepositorySelector.fromSelector((String)restrictByRepository);
            boolean matchesFormat = repository.getFormat().getValue().contains(repositorySelector.getFormat()) || repositorySelector.isAllFormats();
            boolean bl = matchesRepositoryName = repository.getName().contains(repositorySelector.getName()) || repositorySelector.isAllRepositories();
            return matchesFormat && matchesRepositoryName;
        }
        return true;
    }
}

