/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.orient.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.tags.orient.internal.TagEntityAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.common.Strings;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.repository.browse.BrowseSqlBuilderSupport;
import org.sonatype.nexus.repository.query.QueryOptions;

@Named
@Singleton
public class BrowseTagsSqlBuilder
extends BrowseSqlBuilderSupport {
    private final TagEntityAdapter tagEntityAdapter;

    @Inject
    BrowseTagsSqlBuilder(TagEntityAdapter tagEntityAdapter) {
        this.tagEntityAdapter = (TagEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)tagEntityAdapter)));
    }

    protected EntityAdapter<?> getEntityAdapter() {
        return this.tagEntityAdapter;
    }

    protected String getBrowseIndex() {
        return TagEntityAdapter.I_TAG_NAME;
    }

    String buildBrowseSql(QueryOptions queryOptions) {
        StringBuilder queryBuilder = this.buildBase(queryOptions);
        String where = this.buildWhereClause(queryOptions);
        if (!Strings.isNullOrEmpty((String)where)) {
            queryBuilder.append(" WHERE ").append(where).append(' ');
        }
        queryBuilder.append(this.buildQuerySuffix(queryOptions));
        return queryBuilder.toString();
    }

    String buildWhereClause(QueryOptions queryOptions) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (queryOptions.getFilter() != null) {
            whereClauses.add("name LIKE :nameFilter ");
        }
        if (queryOptions.getLastId() != null) {
            whereClauses.add("@rid > :rid");
        }
        return whereClauses.stream().map(clause -> "(" + clause + ")").collect(Collectors.joining(" AND "));
    }

    Map<String, Object> buildSqlParams(QueryOptions queryOptions) {
        String lastId;
        HashMap<String, Object> params = new HashMap<String, Object>();
        String filter = queryOptions.getFilter();
        if (filter != null) {
            String filterValue = "%" + filter + "%";
            params.put("nameFilter", filterValue);
        }
        if ((lastId = queryOptions.getLastId()) != null) {
            params.put("rid", lastId);
        }
        return params;
    }
}

