/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.service.TagNotFoundException;
import com.sonatype.nexus.tags.service.TagService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.ComponentUploadExtension;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.upload.ComponentUpload;

@Singleton
@Named
public class OrientTagComponentUploadExtension
extends ComponentSupport
implements ComponentUploadExtension {
    private final TagService tagService;

    @Inject
    public OrientTagComponentUploadExtension(TagService tagService) {
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
    }

    public void apply(Repository repository, ComponentUpload componentUpload, Collection<EntityId> componentIds) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)componentUpload);
        Preconditions.checkNotNull(componentIds);
        TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> this.componentUploadTag(componentUpload).ifPresent(s -> componentIds.forEach(id -> {
            List<Map<String, String>> list = this.tagService.associateById((String)s, repository, (EntityId)id);
        })));
    }

    public void validate(ComponentUpload componentUpload) {
        this.componentUploadTag((ComponentUpload)Preconditions.checkNotNull((Object)componentUpload)).ifPresent(s -> {
            Tag realTag = this.tagService.get((String)s);
            if (realTag == null) {
                throw new TagNotFoundException((String)s);
            }
        });
    }

    private Optional<String> componentUploadTag(ComponentUpload componentUpload) {
        return Optional.ofNullable(componentUpload.getField("tag"));
    }
}

