/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags;

import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.TagData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="tagExport")
@Singleton
public class TagExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final TagStore store;

    @Inject
    public TagExport(TagStore store) {
        this.store = store;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export Tag data to {}", (Object)file);
        List<Tag> tags = this.store.list();
        this.exportToJson(tags, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring Tag data from {}", (Object)file);
        this.importFromJson(file, TagData.class).forEach(this.store::create);
    }
}

