/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.group;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GroupTemplateWithAttributes
extends GroupTemplate
implements GroupWithAttributes {
    private final Map<String, Set<String>> attributes = new HashMap<String, Set<String>>();

    public GroupTemplateWithAttributes(String groupName, long directoryId, GroupType groupType) {
        super(groupName, directoryId, groupType);
    }

    public GroupTemplateWithAttributes(GroupWithAttributes group) {
        super(group);
        for (String key : group.getKeys()) {
            this.attributes.put(key, new HashSet<String>(group.getValues(key)));
        }
    }

    protected GroupTemplateWithAttributes(Group group) {
        super(group);
    }

    public static GroupTemplateWithAttributes ofGroupWithNoAttributes(Group group) {
        return new GroupTemplateWithAttributes(group);
    }

    public Map<String, Set<String>> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<String> getValues(String name) {
        return this.attributes.get(name);
    }

    @Override
    public String getValue(String name) {
        Set<String> vals = this.getValues(name);
        if (vals != null && vals.size() > 0) {
            return vals.iterator().next();
        }
        return null;
    }

    @Override
    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, Collections.singleton(value));
    }

    public void setAttribute(String name, Set<String> values) {
        this.attributes.put(name, values);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }
}

