/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.io.ScanWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ScanWriterFactory {
    private final Logger log;

    @Inject
    public ScanWriterFactory() {
        this(LoggerFactory.getLogger(ScanWriterFactory.class));
    }

    public ScanWriterFactory(Logger log) {
        this.log = log;
    }

    public ScanWriter newWriter(File scanFile) throws IOException {
        return new ScanWriter(scanFile, this.log);
    }

    public ScanWriter newWriter(Writer writer) {
        return new ScanWriter(writer, this.log);
    }
}

